/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.parser;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.StringCharacterIterator;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.Value;
import org.unitarou.sgf.parser.SgfParserException;

@Deprecated
public class SgfStringFormatter {
    private BufferedWriter writer_;
    private boolean enableCaElement_;
    private boolean writeRegularId_;

    public void format(Collection collection, Writer writer, boolean enableCaElement, boolean writeRegularId) throws SgfParserException {
        try {
            try {
                this.writer_ = new BufferedWriter(writer);
                this.enableCaElement_ = enableCaElement;
                this.writeRegularId_ = writeRegularId;
                if (collection == null || writer == null) {
                    throw new NullPointerException();
                }
                int i = 0;
                while (i < collection.size()) {
                    RootGameTree rootTree = collection.get(i);
                    if (rootTree.getSequence().size() != 0) {
                        Node node = rootTree.getSequence().getFirst();
                        if (!this.enableCaElement_) {
                            node.removeProperty(SgfId.CHARSET.id());
                        }
                        this.format(rootTree);
                    }
                    ++i;
                }
                this.writer_.flush();
            }
            catch (IOException e) {
                throw new SgfParserException(e);
            }
        }
        finally {
            this.writer_ = null;
        }
    }

    private void format(GameTree gameTree) throws IOException {
        this.writer_.write(gameTree.getOpenUtr());
        this.writer_.write(40);
        Node[] nodes = gameTree.getSequence().getNodes();
        int i = 0;
        while (i < nodes.length) {
            this.format(nodes[i]);
            ++i;
        }
        GameTree[] children = gameTree.getChildren();
        int i2 = 0;
        while (i2 < children.length) {
            this.format(children[i2]);
            ++i2;
        }
        this.writer_.write(41);
        this.writer_.write(gameTree.getCloseUtr());
    }

    private void format(Node node) throws IOException {
        this.writer_.write(node.getOpenUtr());
        this.writer_.write(59);
        Property[] properties = node.getProperties();
        int i = 0;
        while (i < properties.length) {
            this.format(properties[i]);
            ++i;
        }
    }

    private void format(Property property) throws IOException {
        this.writer_.write(property.getOpenUtr());
        this.writer_.write(this.writeRegularId_ ? property.getId() : property.getEntireId());
        Value[] values = property.value().getValues();
        int i = 0;
        while (i < values.length) {
            this.writer_.write(values[i].getOpenUtr());
            this.writer_.write(91);
            this.writer_.write(this.escapeBracket(values[i].getString()));
            this.writer_.write(93);
            ++i;
        }
        this.writer_.write(property.getCloseUtr());
    }

    private String escapeBracket(String value) {
        StringBuilder escaped = new StringBuilder();
        StringCharacterIterator ip = new StringCharacterIterator(value);
        char c = ip.first();
        while (c != '\uffff') {
            if (c == '\\') {
                escaped.append(c);
                c = ip.next();
                if (c == '\uffff') {
                    escaped.append('\\');
                    break;
                }
            } else if (c == ']') {
                escaped.append('\\');
            }
            escaped.append(c);
            c = ip.next();
        }
        return escaped.toString();
    }
}

