/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.parser.push;

import java.io.IOException;
import java.io.Reader;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.Sequence;
import org.unitarou.sgf.parser.BadCharsetException;
import org.unitarou.sgf.parser.SgfParserCore;
import org.unitarou.sgf.parser.SgfParserException;
import org.unitarou.sgf.parser.SgfParserLogger;
import org.unitarou.sgf.parser.push.SgfPushParserListener;

public class SgfPushParser
extends SgfParserCore {
    private final Set<SgfPushParserListener> listeners_ = new HashSet<SgfPushParserListener>();

    public void addListener(SgfPushParserListener listener) {
        if (listener == null) {
            return;
        }
        this.listeners_.add(listener);
    }

    public boolean removeListener(SgfPushParserListener listener) {
        return this.listeners_.remove(listener);
    }

    private boolean fireSequenceListener(Sequence sequence, boolean canContinue) {
        boolean listenersVoice = canContinue;
        Iterator<SgfPushParserListener> ip = this.listeners_.iterator();
        while (ip.hasNext()) {
            listenersVoice &= ip.next().sequenceParsed(sequence, canContinue);
        }
        return canContinue & listenersVoice;
    }

    private boolean fireNodeListener(Node node, boolean canContinue) {
        boolean listenersVoice = canContinue;
        Iterator<SgfPushParserListener> ip = this.listeners_.iterator();
        while (ip.hasNext()) {
            listenersVoice &= ip.next().nodeParsed(node, canContinue);
        }
        return canContinue & listenersVoice;
    }

    public Collection parseWithModel(Reader reader) throws SgfParserException {
        this.setParserLogger(new SgfParserLogger());
        Collection collection = new Collection();
        this.setReader(reader);
        try {
            while (this.parseCollection(collection)) {
            }
        }
        catch (IOException e) {
            throw new SgfParserException(e);
        }
        return collection;
    }

    public boolean parseSequence(RootGameTree root, GameTree parent, Sequence sequence) throws IOException, BadCharsetException {
        boolean canContinue = super.parseSequence(root, parent, sequence);
        return this.fireSequenceListener(sequence, canContinue);
    }

    public boolean parseNode(Node node, StringBuilder utr) throws IOException, BadCharsetException {
        boolean canContinue = super.parseNode(node, utr);
        return this.fireNodeListener(node, canContinue);
    }
}

