/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.type;

import org.unitarou.lang.NullArgumentException;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.TypeParseException;
import org.unitarou.sgf.type.TypedString;
import org.unitarou.util.ArgumentChecker;

public class Application
implements TypedString {
    private final String name_;
    private final String version_;

    public static Application parse(String value) throws TypeParseException {
        if (value == null) {
            throw new TypeParseException();
        }
        return new Application(value);
    }

    public static Application create(String name, String version) {
        if (name == null || version == null) {
            throw new NullArgumentException();
        }
        return new Application(name, version);
    }

    private Application(String name, String version) {
        assert (name != null && version != null);
        this.name_ = name;
        this.version_ = version;
    }

    private Application(String value) {
        assert (value != null);
        int sepIndex = value.indexOf(58);
        if (sepIndex > 0) {
            this.name_ = value.substring(0, sepIndex);
            this.version_ = value.substring(sepIndex + 1);
        } else {
            this.name_ = value;
            this.version_ = null;
        }
    }

    public boolean acceptable(SgfId sgfId) {
        ArgumentChecker.throwIfNull((Object)sgfId);
        return sgfId.equals(SgfId.APPLICATION);
    }

    public String getString() {
        StringBuilder stringBuffer = new StringBuilder(this.name_);
        if (this.version_ != null) {
            stringBuffer.append(':').append(this.version_);
        }
        return stringBuffer.toString();
    }

    public String name() {
        return this.name_;
    }

    public String version() {
        return this.version_;
    }

    public int compareTo(Object o) {
        Application app = (Application)o;
        return this.name_.compareTo(app.name_);
    }
}

