/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.type;

import java.util.EnumSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unitarou.lang.NameDisplayable;
import org.unitarou.ml.Messages;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.TypedString;
import org.unitarou.util.ArgumentChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Result
implements TypedString<Result> {
    private static final Pattern scoreCondition_s_ = Pattern.compile("((W|B)\\+)(\\d+(\\.\\d+)?)");
    private static final int ENUM_POS = 1;
    private static final int SCORE_POS = 3;
    private final Archetype archetype_;
    private final double score_;
    private final String value_;

    public static Result parse(String datum) {
        ArgumentChecker.throwIfNull((Object)datum);
        Matcher matched = scoreCondition_s_.matcher(datum);
        if (matched.matches()) {
            Archetype archetype = Archetype.find(matched.group(1));
            double score = Double.parseDouble(matched.group(3));
            return new Result(archetype, score);
        }
        Archetype archetype = Archetype.find(datum);
        if (archetype.equals(Archetype.OTHER)) {
            return new Result(datum);
        }
        return new Result(archetype);
    }

    public Result(Archetype resultEnum) {
        ArgumentChecker.throwIfNull((Object)resultEnum);
        this.archetype_ = resultEnum;
        this.value_ = resultEnum.typeName_;
        this.score_ = 0.0;
    }

    public Result(String value) {
        ArgumentChecker.throwIfNull((Object)value);
        this.archetype_ = Archetype.OTHER;
        this.value_ = value;
        this.score_ = 0.0;
    }

    public Result(Archetype resultEnum, double score) {
        ArgumentChecker.throwIfNull((Object)resultEnum);
        this.archetype_ = resultEnum;
        this.score_ = Archetype.SCORED.contains(this.archetype_) ? score : 0.0;
        this.value_ = this.archetype_.typeName_;
    }

    @Override
    public boolean acceptable(SgfId sgfId) {
        ArgumentChecker.throwIfNull((Object)sgfId);
        return sgfId.equals(SgfId.RESULT);
    }

    @Override
    public String getString() {
        if (Archetype.SCORED.contains(this.archetype_)) {
            return String.valueOf(this.archetype_.typeName_) + String.valueOf(this.score_);
        }
        return this.archetype_.typeName_;
    }

    @Override
    public int compareTo(Result rhs) {
        int c = this.archetype_.typeName_.compareTo(rhs.archetype_.typeName_);
        return c != 0 ? c : (this.score_ - rhs.score_ > 0.0 ? 1 : -1);
    }

    public Archetype getArchetype() {
        return this.archetype_;
    }

    public double getScore() {
        return this.score_;
    }

    public String getValue() {
        return this.value_;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Archetype implements NameDisplayable
    {
        WHITE_WIN("W+"),
        WHITE_RESIGN("W+Resign"),
        WHITE_R("W+R"),
        WHITE_Time("W+Time"),
        WHITE_T("W+T"),
        WHITE_FORFEIT("W+Forfeit"),
        WHITE_F("W+F"),
        BLACK_WIN("B+"),
        BLACK_RESIGN("B+Resign"),
        BLACK_R("B+R"),
        BLACK_Time("B+Time"),
        BLACK_T("B+T"),
        BLACK_FORFEIT("B+Forfeit"),
        BLACK_F("B+F"),
        VOID("Void"),
        UNKNOWN("?"),
        ZERO("0"),
        DRAW("Draw"),
        OTHER("Other");

        public static final EnumSet<Archetype> SCORED;
        private static final Messages messages_s_;
        private static final EnumSet<Archetype> findTargets_s_;
        private final String typeName_;
        private final String displayNameKey_;
        static /* synthetic */ Class class$0;

        static {
            SCORED = EnumSet.of(WHITE_WIN, BLACK_WIN);
            messages_s_ = Messages.createByPackage(Archetype.class);
            EnumSet<Archetype> buf = EnumSet.allOf(Archetype.class);
            buf.remove(OTHER);
            findTargets_s_ = buf;
        }

        public static Archetype find(String typeName) {
            for (Archetype archetype : findTargets_s_) {
                if (!archetype.typeName_.equalsIgnoreCase(typeName)) continue;
                return archetype;
            }
            return OTHER;
        }

        private Archetype(String typeName) {
            ArgumentChecker.throwIfNull((Object)typeName);
            this.typeName_ = typeName;
            this.displayNameKey_ = Messages.createKey(this.getClass(), this.typeName_);
        }

        public String toString() {
            return String.valueOf(this.displayName()) + "(" + this.typeName_ + ")";
        }

        @Override
        public String displayName() {
            return messages_s_.get(this.displayNameKey_);
        }

        public String typeName() {
            return this.typeName_;
        }
    }
}

