/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.type;

import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitarou.lang.NameDisplayable;
import org.unitarou.ml.Messages;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.ValueType;
import org.unitarou.sgf.type.TypeParseException;
import org.unitarou.sgf.type.TypedString;
import org.unitarou.util.ArgumentChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SgfColor
extends Enum<SgfColor>
implements TypedString<SgfColor>,
NameDisplayable {
    public static final /* enum */ SgfColor BLACK = new SgfColor("B");
    public static final /* enum */ SgfColor WHITE = new SgfColor("W");
    private static final Log log_s_;
    private static final Pattern condition_s_;
    private static final int POS = 0;
    private static final Set<SgfId> TYPES_WHITE;
    private static final Set<SgfId> TYPES_BLACK;
    private final String string_;
    private final String displayName_;
    private static final /* synthetic */ SgfColor[] ENUM$VALUES;
    static /* synthetic */ Class class$0;

    static {
        ENUM$VALUES = new SgfColor[]{BLACK, WHITE};
        log_s_ = LogFactory.getLog(SgfColor.class);
        condition_s_ = Pattern.compile("B|W");
        TYPES_WHITE = new TreeSet<SgfId>();
        TYPES_WHITE.add(SgfId.WHITE);
        TYPES_WHITE.add(SgfId.ADD_WHITE);
        TYPES_WHITE.add(SgfId.TERRITORY_WHITE);
        TYPES_WHITE.add(SgfId.WHITE_RANK);
        TYPES_WHITE.add(SgfId.WHITE_TEAM);
        TYPES_WHITE.add(SgfId.WHITE_TIME_LEFT);
        TYPES_WHITE.add(SgfId.GOOD_FOR_WHITE);
        TYPES_BLACK = new TreeSet<SgfId>();
        TYPES_BLACK.add(SgfId.BLACK);
        TYPES_BLACK.add(SgfId.ADD_BLACK);
        TYPES_BLACK.add(SgfId.TERRITORY_BLACK);
        TYPES_BLACK.add(SgfId.BLACK_RANK);
        TYPES_BLACK.add(SgfId.BLACK_TEAM);
        TYPES_BLACK.add(SgfId.BLACK_TIME_LEFT);
        TYPES_WHITE.add(SgfId.GOOD_FOR_BLACK);
    }

    public static SgfColor parse(String value) throws TypeParseException {
        ArgumentChecker.throwIfNull((Object)value);
        Matcher matched = condition_s_.matcher(value);
        if (!matched.matches()) {
            throw new TypeParseException("Bad argument value = " + value);
        }
        String color = matched.group(0);
        return color.equals(SgfColor.BLACK.string_) ? BLACK : WHITE;
    }

    public static SgfColor parseQuietly(String value) {
        try {
            return SgfColor.parse(value);
        }
        catch (TypeParseException e) {
            log_s_.debug("Parse failure: ", e);
            return null;
        }
    }

    public static boolean isValid(String value) {
        ArgumentChecker.throwIfNull((Object)value);
        Matcher matched = condition_s_.matcher(value);
        return matched.matches();
    }

    public static SgfColor getColor(SgfId sgfType) {
        ArgumentChecker.throwIfNull((Object)sgfType);
        if (TYPES_WHITE.contains(sgfType)) {
            return WHITE;
        }
        if (TYPES_BLACK.contains(sgfType)) {
            return BLACK;
        }
        return null;
    }

    public static SgfColor getStoneColor(SgfId sgfType) {
        ArgumentChecker.throwIfNull((Object)sgfType);
        if (SgfId.WHITE.equals(sgfType) || SgfId.ADD_WHITE.equals(sgfType)) {
            return WHITE;
        }
        if (SgfId.BLACK.equals(sgfType) || SgfId.ADD_BLACK.equals(sgfType)) {
            return BLACK;
        }
        return null;
    }

    private SgfColor(String string2) {
        ArgumentChecker.throwIfNull((Object)string2);
        this.string_ = string2;
        this.displayName_ = Messages.createByPackage(SgfColor.class).get(Messages.createKey(SgfColor.class, this.string_));
    }

    public SgfId moveType() {
        if (WHITE.equals(this)) {
            return SgfId.WHITE;
        }
        if (BLACK.equals(this)) {
            return SgfId.BLACK;
        }
        assert (false) : "Unknown type: " + this;
        return null;
    }

    public SgfId setupType() {
        if (WHITE.equals(this)) {
            return SgfId.ADD_WHITE;
        }
        if (BLACK.equals(this)) {
            return SgfId.ADD_BLACK;
        }
        assert (false) : "Unknown type: " + this;
        return null;
    }

    public SgfId timeType() {
        if (WHITE.equals(this)) {
            return SgfId.WHITE_TIME_LEFT;
        }
        if (BLACK.equals(this)) {
            return SgfId.BLACK_TIME_LEFT;
        }
        assert (false) : "Unknown type: " + this;
        return null;
    }

    public SgfColor opposite() {
        return this.equals(BLACK) ? WHITE : BLACK;
    }

    @Override
    public boolean acceptable(SgfId sgfId) {
        ArgumentChecker.throwIfNull((Object)sgfId);
        return ValueType.COLOR.equals((Object)sgfId.valueType());
    }

    @Override
    public String getString() {
        return this.string_;
    }

    @Override
    public String displayName() {
        return this.displayName_;
    }

    public static final SgfColor[] values() {
        SgfColor[] sgfColorArray = ENUM$VALUES;
        int n = sgfColorArray.length;
        SgfColor[] sgfColorArray2 = new SgfColor[n];
        System.arraycopy(ENUM$VALUES, 0, sgfColorArray2, 0, n);
        return sgfColorArray2;
    }

    public static final SgfColor valueOf(String string) {
        SgfColor[] sgfColorArray = ENUM$VALUES;
        int n = ENUM$VALUES.length;
        while (--n >= 0) {
            SgfColor sgfColor = sgfColorArray[n];
            if (!string.equals(sgfColor.name())) continue;
            return sgfColor;
        }
        throw new IllegalArgumentException(string);
    }
}

