/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.type;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.ValueType;
import org.unitarou.sgf.type.TypeParseException;
import org.unitarou.sgf.type.TypedString;
import org.unitarou.util.ArgumentChecker;

public class SgfNumber
implements TypedString {
    private static final Log log_s_ = LogFactory.getLog(SgfNumber.class);
    private static final Pattern condition_s_ = Pattern.compile("(\\+|-)?\\d+");
    private final Integer number_;
    static /* synthetic */ Class class$0;

    public static SgfNumber parse(String value) throws TypeParseException {
        Matcher matched = condition_s_.matcher(value);
        if (!matched.matches()) {
            throw new TypeParseException("Bad argument value = " + value);
        }
        return new SgfNumber(Integer.parseInt(matched.group()));
    }

    public static SgfNumber parseQuietly(String value) {
        try {
            return SgfNumber.parse(value);
        }
        catch (TypeParseException e) {
            log_s_.debug("Bad value for parse: " + value, e);
            return null;
        }
    }

    public SgfNumber(int number) {
        this.number_ = new Integer(number);
    }

    public boolean acceptable(SgfId sgfId) {
        ArgumentChecker.throwIfNull((Object)sgfId);
        return ValueType.NUMBER.equals((Object)sgfId.valueType());
    }

    public String getString() {
        return this.number_ == null ? "" : this.number_.toString();
    }

    public int getIntValue() {
        return this.number_;
    }

    public boolean isValid(String value) {
        return condition_s_.matcher(value).matches();
    }

    public int compareTo(Object o) {
        SgfNumber obj = (SgfNumber)o;
        return this.number_.compareTo(obj.number_);
    }

    public String toString() {
        return this.number_.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        SgfNumber o = (SgfNumber)obj;
        if (o.number_ == null) {
            return this.number_ == null;
        }
        return o.number_.equals(this.number_);
    }

    public int hashCode() {
        return this.number_ == null ? Integer.MIN_VALUE : this.number_.hashCode();
    }
}

