/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.util;

import org.unitarou.sgf.CardinalityType;
import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.Sequence;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.SgfColor;
import org.unitarou.util.ArgumentChecker;

public class BasicFinder {
    public static boolean contains(Property property, String datum) {
        ArgumentChecker.throwIfNull((Object)property, (Object)datum);
        String[] data = property.value().getStrings();
        int i = 0;
        while (i < data.length) {
            if (data[i].equals(datum)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static Node findNode(Sequence sequence, SgfId sgfId) {
        ArgumentChecker.throwIfNull((Object)sequence, (Object)sgfId);
        for (Node node : sequence) {
            Property property = node.getProperty(sgfId);
            if (property == null) continue;
            return node;
        }
        return null;
    }

    public static Property findProperty(Sequence sequence, SgfId sgfId) {
        ArgumentChecker.throwIfNull((Object)sequence, (Object)sgfId);
        for (Node node : sequence) {
            Property property = node.getProperty(sgfId);
            if (property == null) continue;
            return property;
        }
        return null;
    }

    public static String[] findData(Sequence sequence, SgfId sgfId) {
        ArgumentChecker.throwIfNull((Object)sequence, (Object)sgfId);
        for (Node node : sequence) {
            String[] data = BasicFinder.findDataImpl(node, sgfId);
            if (data == null) continue;
            return data;
        }
        return null;
    }

    private static String[] findDataImpl(Node node, SgfId sgfId) {
        Property property = node.getProperty(sgfId);
        return property != null ? property.value().getStrings() : null;
    }

    public static String findDatum(Sequence sequence, SgfId sgfId) {
        ArgumentChecker.throwIfNull((Object)sequence, (Object)sgfId);
        BasicFinder.throwIfMultiType(sgfId);
        for (Node node : sequence) {
            String datum = BasicFinder.findDatumImpl(node, sgfId);
            if ("".equals(datum)) continue;
            return datum;
        }
        return "";
    }

    public static String findDatum(Node node, SgfId sgfId) {
        ArgumentChecker.throwIfNull((Object)node, (Object)sgfId);
        BasicFinder.throwIfMultiType(sgfId);
        return BasicFinder.findDatumImpl(node, sgfId);
    }

    private static String findDatumImpl(Node node, SgfId sgfId) {
        Property property = node.getProperty(sgfId);
        return property != null ? property.value().getString() : "";
    }

    private static void throwIfMultiType(SgfId sgfId) {
        if (!CardinalityType.SINGLE.equals(sgfId.cardinalityType())) {
            throw new IllegalArgumentException("Bad type. " + sgfId.id() + " is LIST or ELIST.");
        }
    }

    public static SgfColor firstMove(RootGameTree rootGameTree) {
        ArgumentChecker.throwIfNull((Object)rootGameTree);
        return BasicFinder.firstMoveImpl(rootGameTree);
    }

    private static SgfColor firstMoveImpl(GameTree gameTree) {
        for (Node node : gameTree.getSequence()) {
            if (node.contains(SgfId.WHITE)) {
                return SgfColor.WHITE;
            }
            if (!node.contains(SgfId.BLACK)) continue;
            return SgfColor.BLACK;
        }
        if (gameTree.getChildrenSize() == 0) {
            return null;
        }
        return BasicFinder.firstMoveImpl(gameTree.getChild(0));
    }

    protected BasicFinder() {
    }
}

