/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.util;

import java.nio.charset.Charset;
import java.util.HashSet;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.FileFormat;
import org.unitarou.sgf.type.GameMode;
import org.unitarou.sgf.type.GameType;
import org.unitarou.sgf.type.Handicap;
import org.unitarou.sgf.type.ProblemProperties;
import org.unitarou.sgf.type.SgfCharset;
import org.unitarou.sgf.type.SgfColor;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.type.Style;
import org.unitarou.util.ArgumentChecker;

public class RootGameTreeFactory {
    public static RootGameTree createGame(SgfSize sgfSize, Handicap handicap) {
        ArgumentChecker.throwIfNull((Object)sgfSize, (Object)handicap);
        RootGameTree rgt = new RootGameTree();
        rgt.setSize(sgfSize);
        rgt.setFileFormat(FileFormat.VERSION_4);
        rgt.setCharset(new SgfCharset(Charset.defaultCharset()));
        rgt.setGameMode(GameMode.IGO);
        rgt.setGameType(GameType.GAME);
        rgt.setStyle(Style.SIBLINGS_SHOW_VAL);
        Node node = rgt.getSequence().getFirst();
        node.addProperty(SgfId.HANDICAP.makeProperty(handicap));
        node.addProperty(SgfId.PLAYER_TO_PLAY.makeProperty(1 < handicap.getIntValue() ? SgfColor.WHITE : SgfColor.BLACK));
        SgfPoint[] handicappedStones = RootGameTreeFactory.composeHandicapStone(sgfSize, handicap);
        if (handicappedStones.length != 0) {
            node.addProperty(SgfId.ADD_BLACK.makeProperty(handicappedStones));
        }
        return rgt;
    }

    private static SgfPoint[] composeHandicapStone(SgfSize sgfSize, Handicap handicap) {
        int hd = handicap.getIntValue();
        if (hd < 2) {
            return new SgfPoint[0];
        }
        if (sgfSize.width() != sgfSize.height()) {
            throw new IllegalArgumentException();
        }
        HashSet<SgfPoint> pointSet = new HashSet<SgfPoint>(9);
        int size = sgfSize.width();
        int left = size + 1;
        int middle = size + 1;
        int right = size + 1;
        if (size < 9) {
            left = size / 5 + 1;
            right = size - left + 1;
            middle = size / 2 + 1;
        } else if (size < 13) {
            left = 3;
            right = size - left + 1;
            middle = size / 2 + 1;
        } else {
            left = 4;
            right = size - left + 1;
            middle = size / 2 + 1;
        }
        switch (hd) {
            case 9: {
                pointSet.add(SgfPoint.create(sgfSize, middle, left));
                pointSet.add(SgfPoint.create(sgfSize, middle, right));
            }
            case 7: {
                pointSet.add(SgfPoint.create(sgfSize, right, middle));
                pointSet.add(SgfPoint.create(sgfSize, left, middle));
            }
            case 5: {
                pointSet.add(SgfPoint.create(sgfSize, middle, middle));
            }
            case 4: {
                pointSet.add(SgfPoint.create(sgfSize, right, right));
            }
            case 3: {
                pointSet.add(SgfPoint.create(sgfSize, left, left));
            }
            case 2: {
                pointSet.add(SgfPoint.create(sgfSize, right, left));
                pointSet.add(SgfPoint.create(sgfSize, left, right));
                break;
            }
            case 8: {
                pointSet.add(SgfPoint.create(sgfSize, middle, left));
                pointSet.add(SgfPoint.create(sgfSize, middle, right));
            }
            case 6: {
                pointSet.add(SgfPoint.create(sgfSize, right, middle));
                pointSet.add(SgfPoint.create(sgfSize, left, middle));
                pointSet.add(SgfPoint.create(sgfSize, right, right));
                pointSet.add(SgfPoint.create(sgfSize, left, left));
                pointSet.add(SgfPoint.create(sgfSize, right, left));
                pointSet.add(SgfPoint.create(sgfSize, left, right));
            }
        }
        return pointSet.toArray(new SgfPoint[pointSet.size()]);
    }

    public static RootGameTree createProblem(SgfSize sgfSize, SgfColor playerToPlay) {
        ArgumentChecker.throwIfNull((Object)sgfSize, (Object)playerToPlay);
        RootGameTree rgt = new RootGameTree();
        rgt.setSize(sgfSize);
        rgt.setFileFormat(FileFormat.VERSION_4);
        rgt.setCharset(new SgfCharset(Charset.defaultCharset()));
        rgt.setGameMode(GameMode.IGO);
        rgt.setGameType(GameType.PROBLEM);
        rgt.setStyle(Style.SIBLINGS_SHOW_VAL);
        Node node = rgt.getSequence().getFirst();
        node.addProperty(SgfId.PLAYER_TO_PLAY.makeProperty(playerToPlay));
        return rgt;
    }

    public static RootGameTree createDrill() {
        RootGameTree rgt = new RootGameTree();
        rgt.setFileFormat(FileFormat.VERSION_4);
        rgt.setCharset(new SgfCharset(Charset.defaultCharset()));
        rgt.setGameMode(GameMode.IGO);
        rgt.setGameType(GameType.DRILL);
        Node node = new Node();
        node.addProperty(SgfId.PROBLEM_PROPERTIES.makeProperty(new ProblemProperties(ProblemProperties.Flag.RETRYABLE)));
        rgt.getSequence().addLast(node);
        return rgt;
    }

    protected RootGameTreeFactory() {
    }
}

