/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.util.SgfPointType;
import org.unitarou.util.ArgumentChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SgfRectangle {
    private SgfPoint start_;
    private SgfPoint end_;

    public static SgfRectangle create(SgfPoint[] sgfPoints) {
        SgfRectangle redrawArea = new SgfRectangle();
        SgfPoint[] sgfPointArray = sgfPoints;
        int n = 0;
        int n2 = sgfPointArray.length;
        while (n < n2) {
            SgfPoint sgfPoint = sgfPointArray[n];
            if (sgfPoint.condition().equals((Object)SgfPointType.IN)) {
                redrawArea.intersect(sgfPoint);
            }
            ++n;
        }
        return redrawArea;
    }

    public static SgfRectangle[] createRegularRectangles(SgfPoint[] sgfPoints) {
        ArrayList<SgfRectangle> list = new ArrayList<SgfRectangle>();
        TreeSet<SgfPoint> workSet = new TreeSet<SgfPoint>((Collection)Arrays.asList(sgfPoints));
        while (!workSet.isEmpty()) {
            SgfPoint element = (SgfPoint)workSet.iterator().next();
            if (!element.condition().equals((Object)SgfPointType.IN)) {
                workSet.remove(element);
                continue;
            }
            SgfRectangle rectangle = SgfRectangle.findBestRectangle(workSet, element);
            list.add(rectangle);
            int x = rectangle.getStart().x();
            while (x <= rectangle.getEnd().x()) {
                int y = rectangle.getStart().y();
                while (y <= rectangle.getEnd().y()) {
                    workSet.remove(SgfPoint.create(element.size(), x, y));
                    ++y;
                }
                ++x;
            }
        }
        return list.toArray(new SgfRectangle[list.size()]);
    }

    private static SgfRectangle findBestRectangle(Set<SgfPoint> pointSet, SgfPoint start) {
        int endX = start.x();
        int x = start.x() + 1;
        while (x <= start.size().width()) {
            SgfPoint point = SgfPoint.create(start.size(), x, start.y());
            if (!pointSet.contains(point)) break;
            endX = x++;
        }
        int endY = start.y();
        int y = start.y() + 1;
        while (y <= start.size().height()) {
            SgfPoint point = SgfPoint.create(start.size(), start.x(), y);
            if (!pointSet.contains(point)) break;
            endY = y++;
        }
        int[] area = new int[endY - start.y() + 1];
        area[0] = endX - start.x() + 1;
        int y2 = start.y() + 1;
        while (y2 <= endY) {
            int lastX = start.x();
            int x2 = start.x() + 1;
            while (x2 <= endX) {
                SgfPoint point = SgfPoint.create(start.size(), x2, y2);
                if (!pointSet.contains(point)) {
                    endX = lastX;
                    break;
                }
                lastX = x2++;
            }
            area[y2 - start.y()] = (y2 - start.y() + 1) * (endX - start.x() + 1);
            ++y2;
        }
        int maxRow = 0;
        int maxArea = area[0];
        int i = 1;
        while (i < area.length) {
            if (maxArea < area[i]) {
                maxArea = area[i];
                maxRow = i;
            }
            ++i;
        }
        int maxCol = maxArea / ++maxRow;
        SgfRectangle ret = new SgfRectangle();
        ret.set(start, SgfPoint.create(start.size(), start.x() + maxCol - 1, start.y() + maxRow - 1));
        return ret;
    }

    public SgfRectangle() {
        SgfSize size = SgfSize.create(52, 52);
        this.start_ = SgfPoint.create(size, size.width(), size.height());
        this.end_ = SgfPoint.create(size, 1, 1);
    }

    public void set(SgfPoint start, SgfPoint end) {
        ArgumentChecker.throwIfNull((Object)start, (Object)end);
        if (!start.size().equals(end.size())) {
            throw new IllegalArgumentException("Inconsistent size: start:" + start.size() + ", end: " + end.size());
        }
        this.start_ = start;
        this.end_ = end;
    }

    public void intersect(SgfPoint point) {
        ArgumentChecker.throwIfNull((Object)point);
        int x1 = Math.min(this.start_.x(), point.x());
        int y1 = Math.min(this.start_.y(), point.y());
        int x2 = Math.min(Math.max(this.end_.x(), point.x()), point.size().width());
        int y2 = Math.min(Math.max(this.end_.y(), point.y()), point.size().height());
        this.start_ = SgfPoint.create(point.size(), x1, y1);
        this.end_ = SgfPoint.create(point.size(), x2, y2);
    }

    public void union(SgfRectangle rectangle) {
        ArgumentChecker.throwIfNull((Object)rectangle);
        int x1 = Math.min(Math.max(this.start_.x(), rectangle.start_.x()), this.start_.size().width());
        int y1 = Math.min(Math.max(this.start_.y(), rectangle.start_.y()), this.start_.size().height());
        int x2 = Math.min(this.end_.x(), rectangle.end_.x());
        int y2 = Math.min(this.end_.y(), rectangle.end_.y());
        this.start_ = SgfPoint.create(this.start_.size(), x1, y1);
        this.end_ = SgfPoint.create(this.start_.size(), x2, y2);
    }

    public SgfPoint getStart() {
        return this.start_;
    }

    public SgfPoint getEnd() {
        return this.end_;
    }

    public int width() {
        return this.end_.x() - this.start_.x() + 1;
    }

    public int height() {
        return this.end_.y() - this.start_.y() + 1;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        SgfRectangle pr = (SgfRectangle)obj;
        return this.start_.equals(pr.start_) && this.end_.equals(pr.end_);
    }

    public int hashCode() {
        return this.start_.hashCode() * 7 + this.end_.hashCode();
    }

    public String getValue() {
        if (this.end_.x() < this.start_.x() && this.end_.y() < this.start_.y()) {
            throw new IllegalArgumentException();
        }
        if (this.start_.equals(this.end_)) {
            return this.start_.getString();
        }
        return String.valueOf(this.start_.getString()) + ':' + this.end_.getString();
    }

    public String toString() {
        if (this.start_.equals(this.end_)) {
            return this.start_.getString();
        }
        return String.valueOf(this.start_.getString()) + ':' + this.end_.getString();
    }
}

