/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.util.filter;

import org.unitarou.sgf.Collection;
import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.Value;
import org.unitarou.util.Filter;
import org.unitarou.util.FilterException;
import org.unitarou.util.NestedFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSgfFilter
extends NestedFilter<Collection> {
    public AbstractSgfFilter() {
    }

    public AbstractSgfFilter(Filter<Collection> parent) {
        super(parent);
    }

    @Override
    public Collection filter(Collection collection) throws FilterException {
        collection = super.filter(collection);
        collection = this.filterCollection(collection);
        Collection ret = new Collection();
        for (RootGameTree rgt : collection) {
            ret.addLast(this.filterRootGameTreeFrame(rgt));
        }
        return ret;
    }

    private RootGameTree filterRootGameTreeFrame(RootGameTree rgt) {
        rgt = this.filterRootGameTree(rgt);
        RootGameTree ret = new RootGameTree(rgt);
        ret.getSequence().clear();
        for (Node node : rgt.getSequence()) {
            ret.getSequence().addLast(this.filterNodeFrame(node));
        }
        ret.clearGameTree();
        GameTree[] gameTreeArray = rgt.getChildren();
        int n = 0;
        int n2 = gameTreeArray.length;
        while (n < n2) {
            GameTree child = gameTreeArray[n];
            ret.addGameTree(this.filterGameTreeFrame(child));
            ++n;
        }
        return ret;
    }

    private GameTree filterGameTreeFrame(GameTree gameTree) {
        gameTree = this.filterGameTree(gameTree);
        GameTree ret = new GameTree(gameTree);
        ret.getSequence().clear();
        for (Node node : gameTree.getSequence()) {
            ret.getSequence().addLast(this.filterNodeFrame(node));
        }
        ret.clearGameTree();
        GameTree[] gameTreeArray = gameTree.getChildren();
        int n = 0;
        int n2 = gameTreeArray.length;
        while (n < n2) {
            GameTree child = gameTreeArray[n];
            ret.addGameTree(this.filterGameTreeFrame(child));
            ++n;
        }
        return ret;
    }

    private Node filterNodeFrame(Node node) {
        node = this.filterNode(node);
        Node ret = new Node(node);
        ret.clearProperty();
        Property[] propertyArray = node.getProperties();
        int n = 0;
        int n2 = propertyArray.length;
        while (n < n2) {
            Property property = propertyArray[n];
            if ((property = this.filterPropertyFrame(property)).isValid()) {
                ret.addProperty(property);
            }
            ++n;
        }
        return ret;
    }

    private Property filterPropertyFrame(Property property) {
        if (!(property = this.filterProperty(property)).isValid()) {
            return property;
        }
        Property ret = new Property(property);
        ret.value().clear();
        Value[] valueArray = property.value().getValues();
        int n = 0;
        int n2 = valueArray.length;
        while (n < n2) {
            Value value = valueArray[n];
            ret.value().addValue(this.filterValue(value, ret.sgfId()));
            ++n;
        }
        return ret;
    }

    protected Collection filterCollection(Collection collection) {
        return collection;
    }

    protected RootGameTree filterRootGameTree(RootGameTree rgt) {
        return rgt;
    }

    protected GameTree filterGameTree(GameTree gameTree) {
        return gameTree;
    }

    protected Node filterNode(Node node) {
        return node;
    }

    protected Property filterProperty(Property property) {
        return property;
    }

    protected Value filterValue(Value value, SgfId sgfId) {
        return value;
    }
}

