/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.util.filter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.Value;
import org.unitarou.sgf.ValueType;
import org.unitarou.sgf.type.Label;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.util.filter.ReflectionFilter;
import org.unitarou.sgf.util.filter.Rotate180Filter;
import org.unitarou.sgf.util.filter.Rotate270Filter;
import org.unitarou.sgf.util.filter.Rotate90Filter;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.util.Filter;
import org.unitarou.util.FilterException;
import org.unitarou.util.NestedFilter;
import org.unitarou.util.NullFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicFilter {
    private static final List<Filter<SgfPoint>> coordinateFilters_s_;

    static {
        ArrayList<NestedFilter> list = new ArrayList<NestedFilter>(8);
        list.add(new NullFilter());
        list.add(new Rotate90Filter());
        list.add(new Rotate180Filter());
        list.add(new Rotate270Filter());
        list.add(new ReflectionFilter());
        list.add(new Rotate90Filter(new ReflectionFilter()));
        list.add(new Rotate180Filter(new ReflectionFilter()));
        list.add(new Rotate270Filter(new ReflectionFilter()));
        coordinateFilters_s_ = Collections.unmodifiableList(list);
    }

    public static void mirrorRotate(RootGameTree rootGameTree, int type) throws FilterException {
        ArgumentChecker.throwIfNull((Object)rootGameTree);
        if (type < 0 || coordinateFilters_s_.size() <= type) {
            throw new IllegalArgumentException("Bad type: " + type);
        }
        Filter<SgfPoint> filter = coordinateFilters_s_.get(type);
        BasicFilter.mirrorRotateImpl(rootGameTree, rootGameTree.getSize(), filter);
    }

    private static void mirrorRotateImpl(GameTree gameTree, SgfSize size, Filter<SgfPoint> filter) throws FilterException {
        for (Node node : gameTree.getSequence()) {
            Property[] propertyArray = node.getProperties();
            int n = 0;
            int n2 = propertyArray.length;
            while (n < n2) {
                Property property = propertyArray[n];
                node.removeProperty(property.getId());
                node.addProperty(BasicFilter.mirrorRotateImpl(property, size, filter));
                ++n;
            }
        }
        int i = 0;
        while (i < gameTree.getChildrenSize()) {
            BasicFilter.mirrorRotateImpl(gameTree.getChild(i), size, filter);
            ++i;
        }
    }

    private static Property mirrorRotateImpl(Property property, SgfSize size, Filter<SgfPoint> filter) throws FilterException {
        ValueType type = property.sgfId().valueType();
        if (type.equals((Object)ValueType.MOVE) || type.equals((Object)ValueType.POINT) || type.equals((Object)ValueType.CPOINT)) {
            String[] data = property.value().getStrings();
            SgfPoint[] sgfPoints = SgfPoint.parse(size, data);
            Property newProp = new Property();
            newProp.setId(property.getId());
            int k = 0;
            while (k < sgfPoints.length) {
                SgfPoint p = filter.filter(sgfPoints[k]);
                newProp.value().addValue(new Value(p.getString()));
                ++k;
            }
            return newProp;
        }
        if (property.sgfId().equals(SgfId.LABEL)) {
            Property newProp = new Property();
            newProp.setId(property.getId());
            String[] data = property.value().getStrings();
            int i = 0;
            while (i < data.length) {
                Label label = Label.parseQuietly(size, data[i]);
                if (label != null) {
                    label = new Label(filter.filter(label.getPoint()), label.getLabel());
                    newProp.value().addValue(new Value(label.getString()));
                }
                ++i;
            }
            return newProp;
        }
        return property;
    }

    protected BasicFilter() {
    }
}

