/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.util.filter;

import java.util.EnumSet;
import org.unitarou.lang.Strings;
import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.Value;
import org.unitarou.sgf.ValueType;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.util.Filter;
import org.unitarou.util.FilterException;
import org.unitarou.util.NestedFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InsertLineSeparatorFilter
extends NestedFilter<Collection> {
    private int maxLine_;
    private int currentLine_;
    private final EnumSet<Option> options_;
    static /* synthetic */ Class class$0;

    public InsertLineSeparatorFilter() {
        this((Filter<Collection>)null);
    }

    public InsertLineSeparatorFilter(int maxLine) {
        this(null, maxLine);
    }

    public InsertLineSeparatorFilter(Filter<Collection> parent) {
        this(parent, 80);
    }

    public InsertLineSeparatorFilter(Filter<Collection> parent, int maxLine) {
        super(parent);
        ArgumentChecker.throwIfNegative(maxLine);
        this.options_ = EnumSet.noneOf(Option.class);
        this.maxLine_ = maxLine;
        this.currentLine_ = 0;
    }

    public void setOption(EnumSet<Option> options) {
        ArgumentChecker.throwIfNull(options);
        this.options_.clear();
        this.options_.addAll(options);
    }

    public EnumSet<Option> getOptions() {
        return this.options_.clone();
    }

    @Override
    public Collection filter(Collection collection) throws FilterException {
        collection = super.filter(collection);
        Collection ret = new Collection();
        for (RootGameTree rgt : collection) {
            ret.addLast(this.filterRootGameTreeFrame(rgt));
        }
        return ret;
    }

    private RootGameTree filterRootGameTreeFrame(RootGameTree rgt) {
        RootGameTree ret = new RootGameTree(rgt);
        ret.setOpenUtr(this.insertLineSeparatorForUtr(ret.getOpenUtr()));
        ++this.currentLine_;
        ret.getSequence().clear();
        for (Node node : rgt.getSequence()) {
            ret.getSequence().addLast(this.filterNodeFrame(node));
        }
        ret.clearGameTree();
        GameTree[] gameTreeArray = rgt.getChildren();
        int n = 0;
        int n2 = gameTreeArray.length;
        while (n < n2) {
            GameTree child = gameTreeArray[n];
            ret.addGameTree(this.filterGameTreeFrame(child));
            ++n;
        }
        ++this.currentLine_;
        ret.setCloseUtr(this.insertLineSeparatorForUtr(ret.getCloseUtr()));
        return ret;
    }

    private GameTree filterGameTreeFrame(GameTree gameTree) {
        GameTree ret = new GameTree(gameTree);
        ret.setOpenUtr(this.insertLineSeparatorForUtr(ret.getOpenUtr()));
        ++this.currentLine_;
        ret.getSequence().clear();
        for (Node node : gameTree.getSequence()) {
            ret.getSequence().addLast(this.filterNodeFrame(node));
        }
        ret.clearGameTree();
        GameTree[] gameTreeArray = gameTree.getChildren();
        int n = 0;
        int n2 = gameTreeArray.length;
        while (n < n2) {
            GameTree child = gameTreeArray[n];
            ret.addGameTree(this.filterGameTreeFrame(child));
            ++n;
        }
        ++this.currentLine_;
        ret.setCloseUtr(this.insertLineSeparatorForUtr(ret.getCloseUtr()));
        return ret;
    }

    private Node filterNodeFrame(Node node) {
        Node ret = new Node(node);
        ret.setOpenUtr(this.insertLineSeparatorForUtr(ret.getOpenUtr()));
        ++this.currentLine_;
        ret.clearProperty();
        Property[] propertyArray = node.getProperties();
        int n = 0;
        int n2 = propertyArray.length;
        while (n < n2) {
            Property property = propertyArray[n];
            if ((property = this.filterPropertyFrame(property)).isValid()) {
                ret.addProperty(property);
            }
            ++n;
        }
        ret.setCloseUtr(this.insertLineSeparatorForUtr(ret.getCloseUtr()));
        return ret;
    }

    private Property filterPropertyFrame(Property property) {
        Property ret = new Property(property);
        ret.setOpenUtr(this.insertLineSeparatorForUtr(ret.getOpenUtr()));
        this.updateString(ret.getEntireId());
        ret.value().clear();
        Value[] values = property.value().getValues();
        boolean lbString = this.usesSoftLineBreak(ret.sgfId().valueType());
        int i = 0;
        while (i < values.length) {
            ret.value().addValue(this.filterValue(values[i], i != 0, lbString));
            ++i;
        }
        ret.setCloseUtr(this.insertLineSeparatorForUtr(ret.getCloseUtr()));
        return ret;
    }

    private boolean usesSoftLineBreak(ValueType valueType) {
        return valueType.equals((Object)ValueType.TEXT) && this.options_.contains((Object)Option.USE_SLB_FOR_TEXT) || valueType.equals((Object)ValueType.SIMPLE_TEXT) && this.options_.contains((Object)Option.USE_SLB_FOR_SIMPLETEXT);
    }

    private Value filterValue(Value value, boolean lbInUtr, boolean lbString) {
        Value ret = new Value(value);
        if (lbInUtr) {
            ret.setOpenUtr(this.insertLineSeparatorForUtr(ret.getOpenUtr()));
        } else {
            this.updateString(ret.getOpenUtr());
        }
        ++this.currentLine_;
        if (lbString) {
            ret.setString(this.insertLineSeparator(ret.getString(), "\\" + Strings.LINE_SEPARATOR));
        } else {
            this.updateString(ret.getString());
        }
        ++this.currentLine_;
        return ret;
    }

    private void updateString(String string) {
        int i = 0;
        while (i < string.length()) {
            char c = string.charAt(i);
            switch (c) {
                case '\n': 
                case '\r': {
                    this.currentLine_ = 0;
                    break;
                }
                default: {
                    this.currentLine_ += c < '\u00ff' ? 1 : 2;
                }
            }
            ++i;
        }
    }

    private String insertLineSeparatorForUtr(String string) {
        return this.insertLineSeparator(string, Strings.LINE_SEPARATOR);
    }

    private String insertLineSeparator(String string, String lineSeparator) {
        StringBuilder builder = new StringBuilder(string.length() + (this.currentLine_ + string.length()) / this.maxLine_ * lineSeparator.length());
        if (this.maxLine_ <= this.currentLine_) {
            builder.append(lineSeparator);
            this.currentLine_ = 0;
        }
        int i = 0;
        while (i < string.length()) {
            char c = string.charAt(i);
            builder.append(c);
            switch (c) {
                case '\n': 
                case '\r': {
                    this.currentLine_ = 0;
                }
            }
            if (this.currentLine_ < this.maxLine_) {
                this.currentLine_ += c < '\u00ff' ? 1 : 2;
            } else {
                builder.append(lineSeparator);
                this.currentLine_ = 0;
            }
            ++i;
        }
        return builder.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Option {
        USE_SLB_FOR_TEXT,
        USE_SLB_FOR_SIMPLETEXT;


        public String toString() {
            return new MessageResource(((Object)((Object)this)).getClass(), this.name()).get();
        }
    }
}

