/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.util.filter;

import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.util.SgfPointType;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.util.FilterException;
import org.unitarou.util.NestedFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Rotate180Filter
extends NestedFilter<SgfPoint> {
    public Rotate180Filter() {
        this((NestedFilter<SgfPoint>)null);
    }

    public Rotate180Filter(NestedFilter<SgfPoint> parent) {
        super(parent);
    }

    @Override
    public SgfPoint filter(SgfPoint sgfPoint) throws FilterException {
        ArgumentChecker.throwIfNull((Object)sgfPoint);
        sgfPoint = super.filter(sgfPoint);
        if (sgfPoint.condition().equals((Object)SgfPointType.PASS)) {
            return sgfPoint;
        }
        SgfSize size = sgfPoint.size();
        int x = size.width() - sgfPoint.x() + 1;
        int y = size.height() - sgfPoint.y() + 1;
        if (x <= size.width() && y <= size.height()) {
            return SgfPoint.create(sgfPoint.size(), x, y);
        }
        throw new FilterException();
    }
}

