/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.util.filter;

import java.util.HashSet;
import java.util.Set;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.util.filter.AbstractSgfFilter;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.util.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SieveBySgfIdFilter
extends AbstractSgfFilter {
    private final Set<SgfId> included_ = new HashSet<SgfId>();

    public SieveBySgfIdFilter() {
        this((Filter<Collection>)null);
    }

    public SieveBySgfIdFilter(SgfId ... sgfIds) {
        this((Filter<Collection>)null, sgfIds);
    }

    public SieveBySgfIdFilter(Filter<Collection> parent) {
        this(parent, new SgfId[0]);
    }

    public SieveBySgfIdFilter(Filter<Collection> parent, SgfId ... sgfIds) {
        super(parent);
        this.setSgfIds(sgfIds);
    }

    public final void setSgfIds(SgfId ... sgfIds) {
        this.included_.clear();
        SgfId[] sgfIdArray = sgfIds;
        int n = 0;
        int n2 = sgfIdArray.length;
        while (n < n2) {
            SgfId sgfId = sgfIdArray[n];
            this.included_.add(sgfId);
            ++n;
        }
    }

    @Override
    protected Property filterProperty(Property property) {
        ArgumentChecker.throwIfNull((Object)property);
        if (this.included_.contains(property.sgfId())) {
            return property;
        }
        return new Property();
    }
}

