/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.util.provider.crdlp;

import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.util.SgfPointType;
import org.unitarou.sgf.util.provider.crdlp.CoordinatesLabelProvider;
import org.unitarou.util.ArgumentChecker;

public class JapaneseStyleProvider
implements CoordinatesLabelProvider {
    private static final MessageResource LB_DISPLAY_NAME = new MessageResource(JapaneseStyleProvider.class, "lbDisplayName");
    private static final char[] KANSUJI = new char[]{'\u4e00', '\u4e8c', '\u4e09', '\u56db', '\u4e94', '\u516d', '\u4e03', '\u516b', '\u4e5d'};
    private static final char[] KANSUJI_10 = new char[]{'\u5341', '\u4e8c', '\u4e09', '\u56db', '\u4e94', '\u516d', '\u4e03', '\u516b', '\u4e5d'};
    private static final String[] KANSUJI_LABEL = new String[52];
    static /* synthetic */ Class class$0;

    static {
        StringBuilder sb = new StringBuilder(3);
        int i = 1;
        while (i <= 52) {
            int posTen = i / 10;
            int posOne = i % 10;
            if (posTen != 0 && i != 10) {
                sb.append(KANSUJI_10[posTen - 1]);
            }
            if (posOne == 0) {
                sb.append(KANSUJI_10[0]);
            } else {
                sb.append(KANSUJI[posOne - 1]);
            }
            JapaneseStyleProvider.KANSUJI_LABEL[i - 1] = sb.toString();
            sb.delete(0, sb.length());
            ++i;
        }
    }

    public String getXLabel(SgfPoint sgfPoint) {
        ArgumentChecker.throwIfNull((Object)sgfPoint);
        return String.valueOf(sgfPoint.x());
    }

    public String getYLabel(SgfPoint sgfPoint) {
        ArgumentChecker.throwIfNull((Object)sgfPoint);
        return KANSUJI_LABEL[sgfPoint.y() - 1];
    }

    public String getMoveLabel(SgfPoint sgfPoint) {
        ArgumentChecker.throwIfNull((Object)sgfPoint);
        if (sgfPoint.condition().equals((Object)SgfPointType.PASS)) {
            return CoordinatesLabelProvider.LB_PASS.get();
        }
        return String.valueOf(this.getXLabel(sgfPoint)) + "\u306e" + this.getYLabel(sgfPoint);
    }

    public String displayName() {
        return LB_DISPLAY_NAME.get();
    }
}

