/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.swt;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.unitarou.ml.MessageResource;
import org.unitarou.swt.EnumSelectionListener;
import org.unitarou.swt.ListenerList;
import org.unitarou.swt.WidgetContainer;
import org.unitarou.util.ArgumentChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumCombo<E extends Enum<E>>
implements WidgetContainer {
    private static final MessageResource LB_EMPTY = new MessageResource(EnumCombo.class, "lbEmpty");
    private final ListenerList<EnumSelectionListener<E>> list_;
    private final EnumSet<E> items_;
    private Combo combo_;
    private final EnumSet<Style> style_;
    private final List<E> enumList_;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public EnumCombo(EnumSet<E> items) {
        this(items, EnumSet.of(Style.READ_ONLY, Style.PERMIT_NO_CHOICE));
    }

    public EnumCombo(EnumSet<E> items, EnumSet<Style> style) {
        ArgumentChecker.throwIfNull(items, style);
        this.list_ = new ListenerList<EnumSelectionListener>(EnumSelectionListener.class);
        this.items_ = items.clone();
        this.combo_ = null;
        this.style_ = style;
        this.enumList_ = new ArrayList(items.size() + (style.contains((Object)Style.PERMIT_NO_CHOICE) ? 1 : 0));
    }

    @Override
    public Control createContents(Composite parent) {
        this.combo_ = new Combo(parent, 4 | (this.style_.contains((Object)Style.READ_ONLY) ? 8 : 0));
        if (this.style_.contains((Object)Style.PERMIT_NO_CHOICE)) {
            this.combo_.add(LB_EMPTY.get());
            this.enumList_.add(null);
        }
        for (Enum item : this.items_) {
            this.combo_.add(item.toString());
            this.enumList_.add(item);
        }
        if (this.combo_.getItemCount() != 0) {
            this.combo_.select(0);
        }
        this.combo_.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EnumCombo.this.fireItemSelected();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                EnumCombo.this.fireDefaultSelected();
            }
        });
        return this.combo_;
    }

    private void fireItemSelected() {
        E item = this.getSelected();
        EnumSelectionListener<E>[] enumSelectionListenerArray = this.list_.getListeners();
        int n = 0;
        int n2 = enumSelectionListenerArray.length;
        while (n < n2) {
            EnumSelectionListener<E> listener = enumSelectionListenerArray[n];
            listener.itemSelected(item);
            ++n;
        }
    }

    private void fireDefaultSelected() {
        String text = this.combo_.getText();
        EnumSelectionListener<E>[] enumSelectionListenerArray = this.list_.getListeners();
        int n = 0;
        int n2 = enumSelectionListenerArray.length;
        while (n < n2) {
            EnumSelectionListener<E> listener = enumSelectionListenerArray[n];
            listener.defaultSelected(text);
            ++n;
        }
    }

    public Combo getCombo() {
        return this.combo_;
    }

    public void select(E item) {
        if (this.combo_ == null) {
            return;
        }
        int index = 0;
        for (Enum e : this.enumList_) {
            if (e == item) {
                this.combo_.select(index);
                return;
            }
            ++index;
        }
    }

    public E getSelected() {
        int index = this.combo_.getSelectionIndex();
        if (index == -1) {
            return null;
        }
        return (E)((Enum)this.enumList_.get(index));
    }

    public String getText() {
        return this.combo_.getText();
    }

    public void setText(String string) {
        this.combo_.setText(string);
    }

    public boolean isEnabled() {
        return this.combo_.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        this.combo_.setEnabled(enabled);
    }

    @Override
    public void dispose() {
    }

    public void addListener(EnumSelectionListener<E> listener) {
        this.list_.add(listener);
    }

    public void removeListener(EnumSelectionListener<E> listener) {
        this.list_.remove(listener);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Style {
        READ_ONLY,
        PERMIT_NO_CHOICE;

    }
}

