/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.swt;

import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.graphics.Point;
import org.unitarou.util.ArgumentChecker;

public class Line {
    private final Point s_;
    private final Point e_;

    public Line(Point s, Point e) {
        ArgumentChecker.throwIfNull((Object)s, (Object)e);
        if (s.equals(e)) {
            throw new IllegalArgumentException();
        }
        if (s.x < e.x) {
            this.s_ = new Point(s.x, s.y);
            this.e_ = new Point(e.x, e.y);
        } else {
            this.s_ = new Point(e.x, e.y);
            this.e_ = new Point(s.x, s.y);
        }
    }

    public double distance(Point t) {
        ArgumentChecker.throwIfNull((Object)t);
        if (this.e_.x == this.s_.x && Math.min(this.s_.y, this.e_.y) < t.y && t.y < Math.max(this.s_.y, this.e_.y)) {
            return Math.abs(this.s_.x - t.x);
        }
        if (this.e_.y == this.s_.y && this.s_.x < t.x && t.x < this.e_.x) {
            return Math.abs(this.s_.y - t.y);
        }
        if (t.x < this.s_.x) {
            return Math.sqrt(Geometry.distanceSquared(t, this.s_));
        }
        if (this.e_.x < t.x) {
            return Math.sqrt(Geometry.distanceSquared(t, this.e_));
        }
        double a = this.e_.x - this.s_.x;
        double b = this.e_.y - this.s_.y;
        double a2 = a * a;
        double b2 = b * b;
        return Math.abs(Math.sqrt(b2 + a2) / (b2 + a2) * (b * (double)(this.s_.x - t.x) - a * (double)(this.s_.y - t.y)));
    }
}

