/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.swt;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;
import org.unitarou.swt.USashFormData;
import org.unitarou.swt.USashFormLayout;

public class USashForm
extends Composite {
    private int sashWidth_ = 3;
    private int sashStyle_;
    private Sash[] sashes_ = new Sash[0];
    private Color background_ = null;
    private Color foreground_ = null;
    private Control[] controls_ = new Control[0];
    private Control maxControl_ = null;
    private final Listener sashListener_;
    private final PaintListener sashPaintaListener_;

    public USashForm(Composite parent, int style) {
        super(parent, USashForm.checkStyle(style));
        super.setLayout(new USashFormLayout());
        int n = this.sashStyle_ = (style & 0x200) != 0 ? 256 : 512;
        if ((style & 0x800) != 0) {
            this.sashStyle_ |= 0x800;
        }
        if ((style & 0x10000) != 0) {
            this.sashStyle_ |= 0x10000;
        }
        this.sashListener_ = new Listener(){

            public void handleEvent(Event e) {
                USashForm.this.onDragSash(e);
            }
        };
        this.sashPaintaListener_ = new PaintListener(){

            public void paintControl(PaintEvent e) {
                Sash sash = (Sash)e.widget;
                Color colBar1 = sash.getDisplay().getSystemColor(20);
                Color colBar2 = sash.getDisplay().getSystemColor(18);
                Point p = sash.getSize();
                if ((sash.getStyle() & 0x100) != 0) {
                    int y1 = p.y / 2;
                    int y2 = y1 + 1;
                    e.gc.setForeground(colBar1);
                    e.gc.drawLine(0, y1, p.x, y1);
                    e.gc.setForeground(colBar2);
                    e.gc.drawLine(0, y2, p.x, y2);
                } else {
                    int x1 = p.x / 2;
                    int x2 = x1 + 1;
                    e.gc.setForeground(colBar1);
                    e.gc.drawLine(x1, 0, x1, p.y);
                    e.gc.setForeground(colBar2);
                    e.gc.drawLine(x2, 0, x2, p.y);
                }
            }
        };
    }

    private static int checkStyle(int style) {
        int mask = 0x6000800;
        return style & mask;
    }

    public int getOrientation() {
        return (this.sashStyle_ & 0x200) != 0 ? 256 : 512;
    }

    public int getStyle() {
        int style = super.getStyle();
        style |= this.getOrientation() == 512 ? 512 : 256;
        if ((this.sashStyle_ & 0x10000) != 0) {
            style |= 0x10000;
        }
        return style;
    }

    public Control getMaximizedControl() {
        return this.maxControl_;
    }

    public int[] getWeights() {
        this.checkWidget();
        Control[] cArray = this.getControls(false);
        int[] ratios = new int[cArray.length];
        int i = 0;
        while (i < cArray.length) {
            Object data = cArray[i].getLayoutData();
            ratios[i] = data != null && data instanceof USashFormData ? (int)(((USashFormData)data).weight * 1000L >> 16) : 200;
            ++i;
        }
        return ratios;
    }

    Control[] getControls(boolean onlyVisible) {
        Control[] children = this.getChildren();
        Control[] result = new Control[]{};
        int i = 0;
        while (i < children.length) {
            if (!(children[i] instanceof Sash || onlyVisible && !children[i].getVisible())) {
                Control[] newResult = new Control[result.length + 1];
                System.arraycopy(result, 0, newResult, 0, result.length);
                newResult[result.length] = children[i];
                result = newResult;
            }
            ++i;
        }
        return result;
    }

    void onDragSash(Event event) {
        Sash sash = (Sash)event.widget;
        int sashIndex = -1;
        int i = 0;
        while (i < this.sashes_.length) {
            if (this.sashes_[i] == sash) {
                sashIndex = i;
                break;
            }
            ++i;
        }
        if (sashIndex == -1) {
            return;
        }
        Control c1 = this.controls_[sashIndex];
        Control c2 = this.controls_[sashIndex + 1];
        this.checkAndCreateLayoutData(c1);
        this.checkAndCreateLayoutData(c2);
        Rectangle b1 = c1.getBounds();
        Rectangle b2 = c2.getBounds();
        USashFormData data1 = (USashFormData)c1.getLayoutData();
        USashFormData data2 = (USashFormData)c2.getLayoutData();
        Rectangle sashBounds = sash.getBounds();
        Rectangle area = this.getClientArea();
        boolean correction = false;
        if (this.getOrientation() == 256) {
            correction = b1.width < data1.getDragMinimum() || b2.width < data2.getDragMinimum();
            int totalWidth = b2.x + b2.width - b1.x;
            int shift = event.x - sashBounds.x;
            b1.width += shift;
            b2.x += shift;
            b2.width -= shift;
            if (b1.width < data1.getDragMinimum()) {
                b1.width = data1.getDragMinimum();
                b2.x = b1.x + b1.width + sashBounds.width;
                b2.width = totalWidth - b2.x;
                event.x = b1.x + b1.width;
                event.doit = false;
            }
            if (b2.width < data2.getDragMinimum()) {
                b1.width = totalWidth - data2.getDragMinimum() - sashBounds.width;
                b2.x = b1.x + b1.width + sashBounds.width;
                b2.width = data2.getDragMinimum();
                event.x = b1.x + b1.width;
                event.doit = false;
            }
            this.updateHorizontalLayoutData(area, c1, b1);
            this.updateHorizontalLayoutData(area, c2, b2);
        } else {
            correction = b1.height < data1.getDragMinimum() || b2.height < data2.getDragMinimum();
            int totalHeight = b2.y + b2.height - b1.y;
            int shift = event.y - sashBounds.y;
            b1.height += shift;
            b2.y += shift;
            b2.height -= shift;
            if (b1.height < data1.getDragMinimum()) {
                b1.height = data1.getDragMinimum();
                b2.y = b1.y + b1.height + sashBounds.height;
                b2.height = totalHeight - b2.y;
                event.y = b1.y + b1.height;
                event.doit = false;
            }
            if (b2.height < data2.getDragMinimum()) {
                b1.height = totalHeight - data2.getDragMinimum() - sashBounds.height;
                b2.y = b1.y + b1.height + sashBounds.height;
                b2.height = data2.getDragMinimum();
                event.y = b1.y + b1.height;
                event.doit = false;
            }
            this.updateVerticalLayoutData(area, c1, b1);
            this.updateVerticalLayoutData(area, c2, b2);
        }
        if (correction || event.doit && event.detail != 1) {
            c1.setBounds(b1);
            sash.setBounds(event.x, event.y, event.width, event.height);
            c2.setBounds(b2);
        }
    }

    private void checkAndCreateLayoutData(Control control) {
        Object data1 = control.getLayoutData();
        if (data1 == null || !(data1 instanceof USashFormData)) {
            control.setLayoutData(new USashFormData());
        }
    }

    private void updateHorizontalLayoutData(Rectangle area, Control control, Rectangle bound) {
        USashFormData data1 = (USashFormData)control.getLayoutData();
        if (data1.getActualSize() > 0) {
            data1.setActualSize(bound.width);
        } else {
            data1.weight = (((long)bound.width << 16) + (long)area.width - 1L) / (long)area.width;
        }
    }

    private void updateVerticalLayoutData(Rectangle area, Control control, Rectangle bound) {
        USashFormData data1 = (USashFormData)control.getLayoutData();
        if (data1.getActualSize() > 0) {
            data1.setActualSize(bound.height);
        } else {
            data1.weight = (((long)bound.height << 16) + (long)area.height - 1L) / (long)area.height;
        }
    }

    public void setOrientation(int orientation) {
        this.checkWidget();
        if (this.getOrientation() == orientation) {
            return;
        }
        if (orientation != 256 && orientation != 512) {
            SWT.error(5);
        }
        this.sashStyle_ &= 0xFFFFFCFF;
        this.sashStyle_ |= orientation == 512 ? 256 : 512;
        int i = 0;
        while (i < this.sashes_.length) {
            this.sashes_[i].dispose();
            this.sashes_[i] = this.createSash();
            ++i;
        }
        this.layout(false);
    }

    private Sash createSash() {
        Sash ret = new Sash(this, this.sashStyle_);
        ret.setBackground(this.background_);
        ret.setForeground(this.foreground_);
        ret.addListener(13, this.sashListener_);
        ret.addPaintListener(this.sashPaintaListener_);
        return ret;
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.background_ = color;
        int i = 0;
        while (i < this.sashes_.length) {
            this.sashes_[i].setBackground(this.background_);
            ++i;
        }
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.foreground_ = color;
        int i = 0;
        while (i < this.sashes_.length) {
            this.sashes_[i].setForeground(this.foreground_);
            ++i;
        }
    }

    public void setLayout(Layout layout) {
        this.checkWidget();
    }

    public void setMaximizedControl(Control control) {
        this.checkWidget();
        if (control == null) {
            if (this.maxControl_ != null) {
                this.maxControl_ = null;
                this.layout(false);
                int i = 0;
                while (i < this.sashes_.length) {
                    this.sashes_[i].setVisible(true);
                    ++i;
                }
            }
            return;
        }
        int i = 0;
        while (i < this.sashes_.length) {
            this.sashes_[i].setVisible(false);
            ++i;
        }
        this.maxControl_ = control;
        this.layout(false);
    }

    public void setWeights(int[] weights) {
        this.checkWidget();
        Control[] cArray = this.getControls(false);
        if (weights == null || weights.length != cArray.length) {
            SWT.error(5);
        }
        int[] actualSize = new int[weights.length];
        int total = 0;
        int i = 0;
        while (i < weights.length) {
            if (weights[i] < 0) {
                actualSize[i] = -weights[i];
                weights[i] = 0;
            }
            total += weights[i];
            ++i;
        }
        if (total == 0) {
            SWT.error(5);
        }
        i = 0;
        while (i < cArray.length) {
            Object data = cArray[i].getLayoutData();
            if (data == null || !(data instanceof USashFormData)) {
                data = new USashFormData();
                cArray[i].setLayoutData(data);
            }
            USashFormData formData = (USashFormData)data;
            formData.weight = (((long)weights[i] << 16) + (long)total - 1L) / (long)total;
            formData.setActualSize(actualSize[i]);
            ++i;
        }
        this.layout(false);
    }

    public void setDragMinimums(int[] sizes) {
        this.checkWidget();
        Control[] cArray = this.getControls(false);
        if (sizes == null || sizes.length != cArray.length) {
            SWT.error(5);
        }
        int i = 0;
        while (i < cArray.length) {
            Object data;
            if (sizes[i] < 0) {
                SWT.error(5);
            }
            if ((data = cArray[i].getLayoutData()) == null || !(data instanceof USashFormData)) {
                data = new USashFormData();
                cArray[i].setLayoutData(data);
            }
            USashFormData formData = (USashFormData)data;
            formData.setDragMinimum(sizes[i]);
            ++i;
        }
    }

    public int getSashWidth() {
        return this.sashWidth_;
    }

    public void setSashWidth(int sashWidth) {
        this.sashWidth_ = sashWidth;
    }

    int getWholeSashWidth() {
        return this.sashes_.length > 0 ? this.sashWidth_ + this.sashes_[0].getBorderWidth() * 2 : this.sashWidth_;
    }

    public int getSashStyle() {
        return this.sashStyle_;
    }

    public void setSashStyle(int style) {
        this.sashStyle_ = style;
    }

    boolean updateSashAndControl() {
        int i;
        Sash[] newSashes;
        Rectangle area = this.getClientArea();
        if (area.width <= 1 || area.height <= 1) {
            return false;
        }
        Control[] newControls = this.getControls(true);
        if (this.controls_.length == 0 && newControls.length == 0) {
            return false;
        }
        this.controls_ = newControls;
        if (this.maxControl_ != null && !this.maxControl_.isDisposed()) {
            int i2 = 0;
            while (i2 < this.controls_.length) {
                if (this.controls_[i2] != this.maxControl_) {
                    this.controls_[i2].setBounds(-200, -200, 0, 0);
                } else {
                    this.controls_[i2].setBounds(area);
                }
                ++i2;
            }
            return false;
        }
        if (this.sashes_.length < this.controls_.length - 1) {
            newSashes = new Sash[this.controls_.length - 1];
            System.arraycopy(this.sashes_, 0, newSashes, 0, this.sashes_.length);
            i = this.sashes_.length;
            while (i < newSashes.length) {
                newSashes[i] = this.createSash();
                ++i;
            }
            this.sashes_ = newSashes;
        }
        if (this.sashes_.length > this.controls_.length - 1) {
            if (this.controls_.length == 0) {
                int i3 = 0;
                while (i3 < this.sashes_.length) {
                    this.sashes_[i3].dispose();
                    ++i3;
                }
                this.sashes_ = new Sash[0];
            } else {
                newSashes = new Sash[this.controls_.length - 1];
                System.arraycopy(this.sashes_, 0, newSashes, 0, newSashes.length);
                i = this.controls_.length - 1;
                while (i < this.sashes_.length) {
                    this.sashes_[i].dispose();
                    ++i;
                }
                this.sashes_ = newSashes;
            }
        }
        return this.controls_.length != 0;
    }

    Control[] getControls() {
        Control[] ret = new Control[this.controls_.length];
        System.arraycopy(this.controls_, 0, ret, 0, ret.length);
        return ret;
    }

    Sash[] getSashes() {
        Sash[] ret = new Sash[this.sashes_.length];
        System.arraycopy(this.sashes_, 0, ret, 0, ret.length);
        return ret;
    }
}

