/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.swt;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Sash;
import org.unitarou.swt.USashForm;
import org.unitarou.swt.USashFormData;

class USashFormLayout
extends Layout {
    USashFormLayout() {
    }

    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        USashForm sashForm = (USashForm)composite;
        Control[] cArray = sashForm.getControls(true);
        int width = 0;
        int height = 0;
        if (cArray.length == 0) {
            if (wHint != -1) {
                width = wHint;
            }
            if (hHint != -1) {
                height = hHint;
            }
            return new Point(width, height);
        }
        boolean vertical = sashForm.getOrientation() == 512;
        int maxIndex = 0;
        int maxValue = 0;
        int i = 0;
        while (i < cArray.length) {
            Point size;
            if (vertical) {
                size = cArray[i].computeSize(wHint, -1, flushCache);
                if (size.y > maxValue) {
                    maxIndex = i;
                    maxValue = size.y;
                }
                width = Math.max(width, size.x);
            } else {
                size = cArray[i].computeSize(-1, hHint, flushCache);
                if (size.x > maxValue) {
                    maxIndex = i;
                    maxValue = size.x;
                }
                height = Math.max(height, size.y);
            }
            ++i;
        }
        long[] ratios = new long[cArray.length];
        long total = 0L;
        int i2 = 0;
        while (i2 < cArray.length) {
            Object data = cArray[i2].getLayoutData();
            if (data != null && data instanceof USashFormData) {
                ratios[i2] = ((USashFormData)data).weight;
            } else {
                data = new USashFormData();
                cArray[i2].setLayoutData(data);
                ratios[i2] = 13108L;
                ((USashFormData)data).weight = 13108L;
            }
            total += ratios[i2];
            ++i2;
        }
        int sashwidth = sashForm.getWholeSashWidth();
        if (vertical) {
            height = ratios[maxIndex] == 0L ? (height += maxValue * cArray.length) : (height += (int)(total * (long)maxValue / ratios[maxIndex]));
            height += (cArray.length - 1) * sashwidth;
        } else {
            width = ratios[maxIndex] == 0L ? (width += maxValue * cArray.length) : (width += (int)(total * (long)maxValue / ratios[maxIndex]));
            width += (cArray.length - 1) * sashwidth;
        }
        width += sashForm.getBorderWidth() * 2;
        height += sashForm.getBorderWidth() * 2;
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        return new Point(width, height);
    }

    protected boolean flushCache(Control control) {
        return true;
    }

    protected void layout(Composite composite, boolean flushCache) {
        USashForm sashForm = (USashForm)composite;
        if (!sashForm.updateSashAndControl()) {
            return;
        }
        Control[] controls = sashForm.getControls();
        long[] ratios = new long[controls.length];
        long total = 0L;
        int fixedSize = 0;
        int i = 0;
        while (i < controls.length) {
            Object data = controls[i].getLayoutData();
            if (data == null || !(data instanceof USashFormData)) {
                data = new USashFormData();
                controls[i].setLayoutData(data);
                ((USashFormData)data).weight = 13108L;
            }
            ratios[i] = ((USashFormData)data).weight;
            fixedSize += ((USashFormData)data).getActualSize();
            total += ratios[i];
            ++i;
        }
        Sash[] sashes = sashForm.getSashes();
        Rectangle area = sashForm.getClientArea();
        int sashwidth = sashForm.getWholeSashWidth();
        if (sashForm.getOrientation() == 256) {
            int allocatableWidth = area.width - sashes.length * sashwidth - fixedSize;
            USashFormData formData = (USashFormData)controls[0].getLayoutData();
            int width = this.calcSize(formData, allocatableWidth, total);
            int x = area.x;
            controls[0].setBounds(x, area.y, width, area.height);
            x += width;
            int i2 = 1;
            while (i2 < controls.length - 1) {
                sashes[i2 - 1].setBounds(x, area.y, sashwidth, area.height);
                formData = (USashFormData)controls[i2].getLayoutData();
                width = this.calcSize(formData, allocatableWidth, total);
                controls[i2].setBounds(x += sashwidth, area.y, width, area.height);
                x += width;
                ++i2;
            }
            if (controls.length > 1) {
                sashes[sashes.length - 1].setBounds(x, area.y, sashwidth, area.height);
                width = area.width - (x += sashwidth);
                controls[controls.length - 1].setBounds(x, area.y, width, area.height);
            }
        } else {
            int allocatableHeight = area.height - sashes.length * sashwidth - fixedSize;
            USashFormData formData = (USashFormData)controls[0].getLayoutData();
            int height = this.calcSize(formData, allocatableHeight, total);
            int y = area.y;
            controls[0].setBounds(area.x, y, area.width, height);
            y += height;
            int i3 = 1;
            while (i3 < controls.length - 1) {
                sashes[i3 - 1].setBounds(area.x, y, area.width, sashwidth);
                formData = (USashFormData)controls[i3].getLayoutData();
                height = this.calcSize(formData, allocatableHeight, total);
                controls[i3].setBounds(area.x, y += sashwidth, area.width, height);
                y += height;
                ++i3;
            }
            if (controls.length > 1) {
                sashes[sashes.length - 1].setBounds(area.x, y, area.width, sashwidth);
                height = area.height - (y += sashwidth);
                controls[controls.length - 1].setBounds(area.x, y, area.width, height);
            }
        }
    }

    private int calcSize(USashFormData formData, int allocatableSize, long total) {
        if (formData.getActualSize() > 0) {
            return formData.getActualSize();
        }
        return (int)(formData.weight * (long)allocatableSize / total);
    }
}

