/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.util;

import java.util.Collection;
import org.unitarou.lang.NullArgumentException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArgumentChecker {
    public static void throwIfNull(Object arg1) {
        if (arg1 == null) {
            throw new NullArgumentException(arg1);
        }
    }

    public static void throwIfNull(Object arg1, Object arg2) {
        if (arg1 == null || arg2 == null) {
            throw new NullArgumentException(arg1, arg2);
        }
    }

    public static void throwIfNull(Object arg1, Object arg2, Object arg3) {
        if (arg1 == null || arg2 == null || arg3 == null) {
            throw new NullArgumentException(arg1, arg2, arg3);
        }
    }

    public static void throwIfNull(Object arg1, Object arg2, Object arg3, Object arg4) {
        if (arg1 == null || arg2 == null || arg3 == null || arg4 == null) {
            throw new NullArgumentException(arg1, arg2, arg3, arg4);
        }
    }

    public static void throwIfNull(Object ... args) {
        if (args == null) {
            throw new NullArgumentException("Argument array must not be null.");
        }
        Object[] objectArray = args;
        int n = 0;
        int n2 = objectArray.length;
        while (n < n2) {
            Object obj = objectArray[n];
            if (obj == null) {
                throw new NullArgumentException(args);
            }
            ++n;
        }
    }

    public static void throwIfNegative(int number) {
        if (number < 0) {
            throw new IllegalArgumentException("Argument must not be minus value. Parameter is " + number);
        }
    }

    public static void throwsIfOutOfBounds(int index, Collection<?> collection) {
        ArgumentChecker.throwIfNull((Object)new Integer(index), collection);
        if (index < 0 || collection.size() <= index) {
            throw new IllegalArgumentException();
        }
    }

    protected ArgumentChecker() {
    }
}

