/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.events;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.unitarou.sgf.type.GameType;
import org.unitarou.util.Adaptable;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.events.ActionListener;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.events.HandlerSelector;
import org.unitarou.yukinoshita.events.StateHandler;
import org.unitarou.yukinoshita.model.cmd.Command4NodeList;
import org.unitarou.yukinoshita.view.CollectionViewer;
import org.unitarou.yukinoshita.view.ContextViewer;
import org.unitarou.yukinoshita.view.ControllerStatusViewer;
import org.unitarou.yukinoshita.view.GameViewer;
import org.unitarou.yukinoshita.view.LayoutViewer;
import org.unitarou.yukinoshita.view.NodeListViewer;
import org.unitarou.yukinoshita.view.NodeViewer;
import org.unitarou.yukinoshita.view.OutlineViwer;
import org.unitarou.yukinoshita.view.ProblemStatusViewer;
import org.unitarou.yukinoshita.view.cmd.Command4View;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventBrokerImpl
implements EventBroker {
    private static final Class[] viewAdapters_s_ = new Class[]{CollectionViewer.class, GameViewer.class, NodeListViewer.class, NodeViewer.class, ContextViewer.class, ControllerStatusViewer.class, ProblemStatusViewer.class, OutlineViwer.class, LayoutViewer.class};
    private static final Class[] ctrlAdapters_s_ = new Class[]{ActionListener.class};
    private final Map<Class<?>, Set<Object>> adapterMap_ = new HashMap();
    private final HandlerSelector handlerSelector_ = new HandlerSelector();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;

    public EventBrokerImpl() {
        this.handlerSelector_.setEventBroker(this);
    }

    public void dispose() {
        for (Set<Object> set : this.adapterMap_.values()) {
            set.clear();
        }
        this.adapterMap_.clear();
        this.handlerSelector_.clear();
    }

    @Override
    public void addView(Adaptable view) {
        ArgumentChecker.throwIfNull((Object)view);
        int i = 0;
        while (i < viewAdapters_s_.length) {
            this.addAdapter(view, viewAdapters_s_[i]);
            ++i;
        }
    }

    @Override
    public void removeView(Adaptable view) {
        ArgumentChecker.throwIfNull((Object)view);
        int i = 0;
        while (i < viewAdapters_s_.length) {
            this.removeAdapter(view, viewAdapters_s_[i]);
            ++i;
        }
    }

    public void addController(Adaptable ctrl) {
        ArgumentChecker.throwIfNull((Object)ctrl);
        int i = 0;
        while (i < ctrlAdapters_s_.length) {
            this.addAdapter(ctrl, ctrlAdapters_s_[i]);
            ++i;
        }
    }

    public void removeController(Adaptable ctrl) {
        ArgumentChecker.throwIfNull((Object)ctrl);
        int i = 0;
        while (i < ctrlAdapters_s_.length) {
            this.removeAdapter(ctrl, ctrlAdapters_s_[i]);
            ++i;
        }
    }

    private void addAdapter(Adaptable adaptable, Class<?> clazz) {
        Object obj = adaptable.getAdapter(clazz);
        if (obj == null) {
            return;
        }
        if (!clazz.isInstance(obj)) {
            throw new IllegalArgumentException("Bad adapter: adaptable:" + adaptable + " class:" + clazz + ", but obj:" + obj);
        }
        Set<Object> set = this.adapterMap_.get(clazz);
        if (set == null) {
            set = new HashSet<Object>();
            this.adapterMap_.put(clazz, set);
        }
        set.add(obj);
    }

    private void removeAdapter(Adaptable adaptable, Class<?> clazz) {
        Object obj = adaptable.getAdapter(clazz);
        if (obj == null) {
            return;
        }
        if (!clazz.isInstance(obj)) {
            throw new IllegalArgumentException("Bad adapter: adaptable:" + adaptable + " class:" + clazz + ", but obj:" + obj);
        }
        Set<Object> set = this.adapterMap_.get(clazz);
        if (set != null) {
            set.remove(obj);
        }
    }

    @Override
    public <T> Set<T> getListeners(Class<T> clazz) {
        ArgumentChecker.throwIfNull(clazz);
        Set<Object> set = this.adapterMap_.get(clazz);
        if (set == null) {
            set = new HashSet<Object>();
        }
        HashSet<Object> ret = new HashSet<Object>(set.size());
        for (Object object : set) {
            ret.add(object);
        }
        return ret;
    }

    @Override
    public void register(GameType gameType, boolean isEditMode, StateHandler eventHandler) {
        this.handlerSelector_.put(gameType, isEditMode, eventHandler);
        eventHandler.setEventBroker(this);
    }

    @Override
    public void connect(GameType gameType, boolean isEditMode) {
        this.handlerSelector_.connect(gameType, isEditMode);
    }

    @Override
    public void disconnect() {
        this.handlerSelector_.disconnect();
    }

    @Override
    public StateHandler getCurrentStateHander() {
        return this.handlerSelector_.getCurrent();
    }

    @Override
    public void executeCommand(Command4NodeList command) {
        ArgumentChecker.throwIfNull((Object)command);
        for (ActionListener listener : this.getListeners(ActionListener.class)) {
            listener.executeCommand(command);
        }
    }

    @Override
    public void executeCommand(Command4View command) {
        ArgumentChecker.throwIfNull((Object)command);
        for (ActionListener listener : this.getListeners(ActionListener.class)) {
            listener.executeCommand(command);
        }
    }
}

