/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.events;

import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitarou.sgf.type.GameType;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.events.StateHandler;

class HandlerSelector {
    private static final Log log_s_ = LogFactory.getLog(HandlerSelector.class);
    private final Map<String, StateHandler> handlerMap_ = new TreeMap<String, StateHandler>();
    private StateHandler stateHandler_ = null;
    static /* synthetic */ Class class$0;

    public void put(GameType gameType, boolean isEditMode, StateHandler eventHandler) {
        this.handlerMap_.put(this.makeKey(gameType, isEditMode), eventHandler);
    }

    public void connect(GameType gameType, boolean isEditMode) {
        this.disconnect();
        String key = this.makeKey(gameType, isEditMode);
        this.stateHandler_ = this.handlerMap_.get(key);
        if (this.stateHandler_ == null) {
            log_s_.warn("Can't find StateHandler. key=" + key);
            return;
        }
        this.stateHandler_.connect();
    }

    public void disconnect() {
        if (this.stateHandler_ != null) {
            this.stateHandler_.disconnect();
            this.stateHandler_ = null;
        }
    }

    private String makeKey(GameType gameType, boolean isEditMode) {
        return String.valueOf(gameType.getString()) + isEditMode;
    }

    public void setEventBroker(EventBroker broker) {
        ArgumentChecker.throwIfNull((Object)broker);
        for (StateHandler igoBoardEventHandler : this.handlerMap_.values()) {
            igoBoardEventHandler.setEventBroker(broker);
        }
    }

    public void clear() {
        this.handlerMap_.clear();
        this.stateHandler_ = null;
    }

    public StateHandler getCurrent() {
        return this.stateHandler_;
    }
}

