/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.model;

import java.util.ArrayList;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.util.SgfArgumentChecker;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.model.NodeEntity;
import org.unitarou.yukinoshita.model.NodeList;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.model.board.MarkupIgoBoard;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EditableNodeList
implements NodeList {
    private static final Log log_s_ = LogFactory.getLog(EditableNodeList.class);
    private final RootGameTree root_;
    private final ArrayList<NodeEntity> entityList_;
    private int boardIndex_;
    private int positionIndex_;
    private MarkupIgoBoard igoBoard_;
    static /* synthetic */ Class class$0;

    public EditableNodeList(RootGameTree root) {
        ArgumentChecker.throwIfNull((Object)root);
        this.root_ = root;
        this.igoBoard_ = new MarkupIgoBoard(this.root_.getSize());
        this.entityList_ = new ArrayList(0);
        this.boardIndex_ = -1;
        this.positionIndex_ = -1;
        this.addLast(this.root_);
    }

    public SgfSize getSize() {
        return this.root_.getSize();
    }

    public RootGameTree getRoot() {
        return this.root_;
    }

    void update(NodeEntity nodeEntity) {
        ArgumentChecker.throwIfNull((Object)nodeEntity);
        int index = this.entityList_.indexOf(nodeEntity);
        if (index == -1) {
            throw new IllegalArgumentException("nodeEntity " + nodeEntity + " is not found in entityList_");
        }
        if (index == 0) {
            this.igoBoard_ = new MarkupIgoBoard(this.igoBoard_.size());
            nodeEntity.forwardUpdate(null, this.igoBoard_);
            this.boardIndex_ = -1;
        } else {
            this.updateIgoBoard(this.entityList_.get(index - 1));
        }
    }

    MarkupIgoBoard updateIgoBoard(NodeEntity nodeEntity) {
        ArgumentChecker.throwIfNull((Object)nodeEntity);
        int index = this.entityList_.indexOf(nodeEntity);
        if (index == -1) {
            throw new IllegalArgumentException("nodeEntity " + nodeEntity + " is not found in entityList_");
        }
        if (this.boardIndex_ < index) {
            this.forwardUpdateIgoBoard(index);
            log_s_.debug("forwardUpdateIgoBoard:" + index);
        } else if (index < this.boardIndex_) {
            if (index != 0) {
                this.backwardUpdateIgoBoard(index - 1);
                log_s_.debug("backwardUpdateIgoBoard:" + (index - 1));
                this.forwardUpdateIgoBoard(index);
                log_s_.debug("forwardUpdateIgoBoard:" + index);
            } else {
                this.backwardUpdateIgoBoard(index);
                log_s_.debug("backwardUpdateIgoBoard:" + index);
            }
        }
        return this.igoBoard_;
    }

    private void forwardUpdateIgoBoard(int index) {
        int i = this.boardIndex_ + 1;
        while (i <= index) {
            NodeEntity previous = i == 0 ? null : this.entityList_.get(i - 1);
            this.entityList_.get(i).forwardUpdate(previous, this.igoBoard_);
            ++i;
        }
        this.boardIndex_ = index;
    }

    private void backwardUpdateIgoBoard(int index) {
        if (index == 0) {
            this.igoBoard_ = new MarkupIgoBoard(this.root_.getSize());
            this.boardIndex_ = -1;
            return;
        }
        int i = this.boardIndex_;
        while (i >= index + 1) {
            this.entityList_.get(i).backwardUpdate(this.igoBoard_);
            --i;
        }
        this.boardIndex_ = index;
    }

    private void rollback(int rollBackTo) {
        if (!this.entityList_.isEmpty()) {
            this.updateIgoBoard(this.entityList_.get(rollBackTo));
        }
    }

    public void addLast(GameTree gameTree) {
        ArgumentChecker.throwIfNull((Object)gameTree);
        this.addLastImpl(gameTree);
    }

    private void addLastImpl(GameTree gameTree) {
        for (Node node : gameTree.getSequence()) {
            this.entityList_.add(new NodeEntity(node, gameTree, this, this.entityList_.isEmpty() ? null : this.getLast()));
        }
        GameTree[] children = gameTree.getChildren();
        if (children.length != 0) {
            this.addLastImpl(children[0]);
        }
        SgfArgumentChecker.throwIfInvalid(this.root_);
    }

    public void addLast(NodeEntity[] nodeEntities) {
        ArgumentChecker.throwIfNull((Object)nodeEntities);
        int i = 0;
        while (i < nodeEntities.length) {
            this.entityList_.add(nodeEntities[i]);
            ++i;
        }
    }

    public void addLast(NodeEntity nodeEntity) {
        ArgumentChecker.throwIfNull((Object)nodeEntity);
        this.entityList_.add(nodeEntity);
    }

    public NodeEntity addLast(Node node, GameTree gameTree) {
        ArgumentChecker.throwIfNull((Object)node, (Object)gameTree);
        NodeEntity entity = new NodeEntity(node, gameTree, this, this.entityList_.isEmpty() ? null : this.getLast());
        this.entityList_.add(entity);
        return entity;
    }

    public NodeEntity insert(Node node, GameTree gameTree, NodeEntity insertPoint) {
        SgfArgumentChecker.throwIfNotAChild(node, gameTree);
        int index = this.entityList_.indexOf(insertPoint);
        if (index == -1) {
            throw new IllegalArgumentException();
        }
        NodeEntity previous = null;
        if (index == 0) {
            log_s_.warn("Can't rollback because of zero index");
        } else {
            this.rollback(index - 1);
            previous = this.get(index - 1);
        }
        NodeEntity entity = new NodeEntity(node, gameTree, this, previous);
        this.entityList_.add(index, entity);
        return entity;
    }

    public boolean remove(NodeEntity target) {
        ArgumentChecker.throwIfNull((Object)target);
        int pos = this.entityList_.indexOf(target);
        if (pos > 0) {
            this.entityList_.remove(pos);
            this.rollback(pos);
            return true;
        }
        return false;
    }

    public NodeEntity removeLast() {
        if (this.entityList_.size() == 1) {
            this.igoBoard_ = new MarkupIgoBoard(this.igoBoard_.size());
        } else {
            this.rollback(this.entityList_.size() - 2);
        }
        NodeEntity ret = this.entityList_.remove(this.entityList_.size() - 1);
        return ret;
    }

    public NodeEntity getPosition() {
        return this.get(this.positionIndex_);
    }

    public void setPositionIndex(int newIndex) {
        if (newIndex < 0 || this.entityList_.size() <= newIndex) {
            throw new IndexOutOfBoundsException(String.valueOf(newIndex) + " is out of range (size is " + this.entityList_.size() + ").");
        }
        this.positionIndex_ = newIndex;
    }

    public int getPositionIndex() {
        return this.positionIndex_;
    }

    public NodeEntity get(int index) {
        return this.entityList_.get(index);
    }

    public NodeEntity getLast() {
        if (this.entityList_.isEmpty()) {
            throw new IllegalStateException("Current list is empty.");
        }
        return this.entityList_.get(this.entityList_.size() - 1);
    }

    @Override
    public int size() {
        return this.entityList_.size();
    }

    public boolean contains(NodeEntity target) {
        return this.entityList_.contains(target);
    }

    @Override
    public NodeView getLastNodeView() {
        return this.getLast().getNodeView();
    }

    @Override
    public NodeView getNodeView(int index) {
        return this.get(index).getNodeView();
    }

    @Override
    public NodeView getCurrentNodeView() {
        return this.getPosition().getNodeView();
    }

    public boolean refresh(Set<SgfId> updateIds) {
        ArgumentChecker.throwIfNull(updateIds);
        if (updateIds.contains(SgfId.SIZE)) {
            this.igoBoard_ = new MarkupIgoBoard(this.root_.getSize());
            this.entityList_.clear();
            this.boardIndex_ = -1;
            this.positionIndex_ = -1;
            this.addLast(this.root_);
            return true;
        }
        return false;
    }
}

