/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.PropertyType;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.GameType;
import org.unitarou.sgf.type.SgfColor;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.type.SgfReal;
import org.unitarou.sgf.type.TimeLapsed;
import org.unitarou.sgf.util.BasicFinder;
import org.unitarou.sgf.util.Stone;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.model.EditableNodeList;
import org.unitarou.yukinoshita.model.NodeTree;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.model.board.IgoBoard;
import org.unitarou.yukinoshita.model.board.InheritableMarker;
import org.unitarou.yukinoshita.model.board.MarkupIgoBoard;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NodeEntity {
    private static final Log log_s_ = LogFactory.getLog(NodeEntity.class);
    public static final int NO_VARIATION = -1;
    private static final String PRE_APPENDED = "appended";
    private static final String PRE_REMOVED = "removed";
    private static final String APPEND_SETUP_BLACK = "appended" + SgfId.ADD_BLACK.id();
    private static final String REMOVE_SETUP_BLACK = "removed" + SgfId.ADD_BLACK.id();
    private static final String APPEND_SETUP_WHITE = "appended" + SgfId.ADD_WHITE.id();
    private static final String REMOVE_SETUP_WHITE = "removed" + SgfId.ADD_WHITE.id();
    private static final Set<SgfId> idSet4Problem_s_ = Collections.unmodifiableSet(new HashSet(Arrays.asList(SgfId.BLACK, SgfId.KO, SgfId.SET_MOVE_NUMBER, SgfId.WHITE, SgfId.ADD_BLACK, SgfId.ADD_EMPTY, SgfId.ADD_WHITE, SgfId.PLAYER_TO_PLAY, SgfId.COMMENT, SgfId.GOOD_FOR_BLACK, SgfId.GOOD_FOR_WHITE, SgfId.BAD_MOVE, SgfId.ARROW, SgfId.CIRCLE, SgfId.DIM_POINTS, SgfId.LABEL, SgfId.LINE, SgfId.MARK_WITH_X, SgfId.SELECTED, SgfId.SQUARE, SgfId.TRIANGLE, SgfId.APPLICATION, SgfId.CHARSET, SgfId.FILE_FORMAT, SgfId.GAME_MODE, SgfId.GAME_TYPE, SgfId.STYLE, SgfId.SIZE, SgfId.BLACK_RANK, SgfId.COPYRIGHT, SgfId.DATE, SgfId.GAME_COMMENT, SgfId.GAME_NAME, SgfId.RESULT, SgfId.SOURCE, SgfId.TIMELIMIT, SgfId.USER, SgfId.VIEW)));
    private static final Set<SgfId> idSet4Drill_s_ = Collections.unmodifiableSet(new HashSet(Arrays.asList(SgfId.APPLICATION, SgfId.CHARSET, SgfId.FILE_FORMAT, SgfId.GAME_MODE, SgfId.GAME_TYPE, SgfId.STYLE, SgfId.BLACK_RANK, SgfId.GAME_COMMENT, SgfId.GAME_NAME, SgfId.INPUT_FILES, SgfId.PROBLEM_PROPERTIES)));
    private final EditableNodeList nodeList_;
    private final Map<String, SgfPoint[]> inheritPointMap_;
    private NodeEntity previous_;
    private final Node node_;
    private int selectedVariationIndex_;
    private final NodeTree nodeTree_;
    private final InheritableMarker inheritableDecoration_;
    private Stone move_;
    private final List<Stone> capturedStones_;
    private final Set<SgfPoint> invalidPoints_;
    private NodeView nodeView_;
    static /* synthetic */ Class class$0;

    public NodeEntity(Node node, GameTree gameTree, EditableNodeList nodeList, NodeEntity previous) {
        ArgumentChecker.throwIfNull((Object)node, (Object)gameTree, (Object)nodeList);
        this.node_ = node;
        this.nodeTree_ = new NodeTree(this.node_, gameTree);
        this.nodeList_ = nodeList;
        this.previous_ = previous;
        this.nodeView_ = null;
        this.inheritPointMap_ = new HashMap<String, SgfPoint[]>();
        this.inheritPointMap_.put(APPEND_SETUP_BLACK, SgfPoint.EMPTY_ARRAY);
        this.inheritPointMap_.put(REMOVE_SETUP_BLACK, SgfPoint.EMPTY_ARRAY);
        this.inheritPointMap_.put(APPEND_SETUP_WHITE, SgfPoint.EMPTY_ARRAY);
        this.inheritPointMap_.put(REMOVE_SETUP_WHITE, SgfPoint.EMPTY_ARRAY);
        for (SgfId sgfType : PropertyType.INHERIT.getSgfTypeSet()) {
            this.inheritPointMap_.put(PRE_APPENDED + sgfType.id(), SgfPoint.EMPTY_ARRAY);
            this.inheritPointMap_.put(PRE_REMOVED + sgfType.id(), SgfPoint.EMPTY_ARRAY);
        }
        this.selectedVariationIndex_ = this.nodeTree_.getVariationSize() == 0 ? -1 : 0;
        this.inheritableDecoration_ = new InheritableMarker();
        this.move_ = Stone.NULL_STONE;
        this.composeMove();
        this.capturedStones_ = new ArrayList<Stone>(0);
        this.invalidPoints_ = new HashSet<SgfPoint>(1);
    }

    public void setSelectedVariationIndex(int index) {
        if (index < 0 || this.nodeTree_.getVariationSize() <= index) {
            throw new IndexOutOfBoundsException();
        }
        this.selectedVariationIndex_ = index;
    }

    void forwardUpdate(NodeEntity previous, MarkupIgoBoard igoBoard) {
        this.previous_ = previous;
        int variations = this.nodeTree_.getVariationSize();
        if (variations == 0) {
            this.selectedVariationIndex_ = -1;
        } else if (variations <= this.selectedVariationIndex_ || this.selectedVariationIndex_ == -1) {
            this.selectedVariationIndex_ = 0;
        }
        this.setStones(SgfColor.BLACK, igoBoard);
        this.setStones(SgfColor.WHITE, igoBoard);
        this.setEmpties(igoBoard);
        this.moveStone(igoBoard);
        this.invalidPoints_.clear();
        this.invalidPoints_.addAll(igoBoard.validate());
        this.updateInheritedDecoration();
    }

    void backwardUpdate(MarkupIgoBoard igoBoard) {
        SgfPoint point;
        int variations = this.nodeTree_.getVariationSize();
        if (variations == 0) {
            this.selectedVariationIndex_ = -1;
        } else if (variations <= this.selectedVariationIndex_ || this.selectedVariationIndex_ == -1) {
            this.selectedVariationIndex_ = 0;
        }
        SgfPoint[] sgfPointArray = this.inheritPointMap_.get(APPEND_SETUP_BLACK);
        int n = 0;
        int n2 = sgfPointArray.length;
        while (n < n2) {
            point = sgfPointArray[n];
            igoBoard.removeStone(point);
            ++n;
        }
        sgfPointArray = this.inheritPointMap_.get(APPEND_SETUP_WHITE);
        n = 0;
        n2 = sgfPointArray.length;
        while (n < n2) {
            point = sgfPointArray[n];
            igoBoard.removeStone(point);
            ++n;
        }
        sgfPointArray = this.inheritPointMap_.get(REMOVE_SETUP_BLACK);
        n = 0;
        n2 = sgfPointArray.length;
        while (n < n2) {
            point = sgfPointArray[n];
            igoBoard.setStone(new Stone(SgfColor.BLACK, point, null));
            ++n;
        }
        sgfPointArray = this.inheritPointMap_.get(REMOVE_SETUP_WHITE);
        n = 0;
        n2 = sgfPointArray.length;
        while (n < n2) {
            point = sgfPointArray[n];
            igoBoard.setStone(new Stone(SgfColor.WHITE, point, null));
            ++n;
        }
        if (this.move_.isValid()) {
            igoBoard.removeStone(this.move_.getPoint());
            for (Stone stone : this.capturedStones_) {
                igoBoard.setStone(stone);
            }
            igoBoard.removeCaptured(this.capturedStones_);
        }
    }

    private void setStones(SgfColor color, IgoBoard igoBoard) {
        Property property = this.node_.getProperty(color.setupType());
        if (property == null) {
            return;
        }
        HashSet<SgfPoint> set = new HashSet<SgfPoint>();
        String[] values = property.value().getStrings();
        SgfPoint[] sgfPointArray = SgfPoint.parse(this.nodeList_.getSize(), values);
        int n = 0;
        int n2 = sgfPointArray.length;
        while (n < n2) {
            SgfPoint sgfPoint = sgfPointArray[n];
            set.add(sgfPoint);
            igoBoard.removeStone(sgfPoint);
            igoBoard.setStone(new Stone(color, sgfPoint, null));
            ++n;
        }
        if (set.isEmpty()) {
            this.inheritPointMap_.put(PRE_APPENDED + color.setupType().id(), SgfPoint.EMPTY_ARRAY);
        } else {
            this.inheritPointMap_.put(PRE_APPENDED + color.setupType().id(), set.toArray(new SgfPoint[set.size()]));
        }
    }

    private void setEmpties(IgoBoard igoBoard) {
        Property property = this.node_.getProperty(SgfId.ADD_EMPTY);
        if (property == null) {
            return;
        }
        HashSet<SgfPoint> blacks = new HashSet<SgfPoint>();
        HashSet<SgfPoint> whites = new HashSet<SgfPoint>();
        String[] values = property.value().getStrings();
        SgfPoint[] sgfPointArray = SgfPoint.parse(this.nodeList_.getSize(), values);
        int n = 0;
        int n2 = sgfPointArray.length;
        while (n < n2) {
            SgfPoint sgfPoint = sgfPointArray[n];
            SgfColor color = igoBoard.removeStone(sgfPoint);
            if (SgfColor.BLACK.equals(color)) {
                blacks.add(sgfPoint);
            } else if (SgfColor.WHITE.equals(color)) {
                whites.add(sgfPoint);
            }
            ++n;
        }
        this.inheritPointMap_.put(REMOVE_SETUP_BLACK, blacks.isEmpty() ? SgfPoint.EMPTY_ARRAY : blacks.toArray(new SgfPoint[blacks.size()]));
        this.inheritPointMap_.put(REMOVE_SETUP_WHITE, whites.isEmpty() ? SgfPoint.EMPTY_ARRAY : whites.toArray(new SgfPoint[whites.size()]));
    }

    private void moveStone(MarkupIgoBoard igoBoard) {
        this.composeMove();
        if (!this.move_.isValid()) {
            return;
        }
        this.capturedStones_.clear();
        this.capturedStones_.addAll((Collection<Stone>)Arrays.asList(igoBoard.moveStone(this.move_)));
    }

    private void composeMove() {
        this.move_ = Stone.NULL_STONE;
        SgfColor[] sgfColorArray = new SgfColor[]{SgfColor.BLACK, SgfColor.WHITE};
        int n = 0;
        int n2 = sgfColorArray.length;
        while (n < n2) {
            SgfPoint point;
            SgfColor sgfColor = sgfColorArray[n];
            Property property = this.node_.getProperty(sgfColor.moveType());
            if (property != null && (point = SgfPoint.parseMoveQuietly(this.nodeList_.getSize(), property.value().getString())) != null) {
                Integer mn = this.composeMoveNumber();
                Double tl = this.composeTimeLapsed(sgfColor);
                this.move_ = new Stone(sgfColor, point, mn, tl);
                return;
            }
            ++n;
        }
    }

    private Integer composeMoveNumber() {
        Property property;
        Integer mn = new Integer(1);
        NodeEntity lastMoveNode = this.previous_;
        while (lastMoveNode != null) {
            if (!lastMoveNode.move_.isValid()) {
                lastMoveNode = lastMoveNode.previous_;
                continue;
            }
            Integer lastMn = lastMoveNode.move_.getNumber();
            if (lastMn == null) break;
            mn = new Integer(lastMn + 1);
            break;
        }
        if ((property = this.node_.getProperty(SgfId.SET_MOVE_NUMBER)) != null) {
            try {
                mn = new Integer(property.value().getString());
            }
            catch (NumberFormatException ignore) {
                ignore.printStackTrace();
            }
        }
        return mn;
    }

    private Double composeTimeLapsed(SgfColor sgfColor) {
        double tl;
        TimeLapsed tl2;
        Property property = this.node_.getProperty(SgfId.TIME_LAPSED);
        if (property != null && (tl2 = TimeLapsed.parseQuietly(property.value().getString())) != null) {
            return new Double(tl2.getTimeLapsed());
        }
        property = this.node_.getProperty(sgfColor.timeType());
        if (property == null) {
            return null;
        }
        SgfReal nowTimeLeft = SgfReal.parseQuietly(property.value().getString());
        if (nowTimeLeft == null) {
            return null;
        }
        SgfReal lastTimeLeft = null;
        NodeEntity lastMoveNode = this.previous_;
        while (lastMoveNode != null) {
            property = lastMoveNode.node_.getProperty(sgfColor.timeType());
            if (property != null) {
                lastTimeLeft = SgfReal.parseQuietly(property.value().getString());
                break;
            }
            lastMoveNode = lastMoveNode.previous_;
        }
        if (lastTimeLeft == null) {
            NodeEntity entity = this.findAbove(PropertyType.GAME_INFO);
            if (entity == null) {
                return null;
            }
            property = entity.node_.getProperty(SgfId.TIMELIMIT);
            if (property == null) {
                return null;
            }
            lastTimeLeft = SgfReal.parseQuietly(property.value().getString());
            if (lastTimeLeft == null) {
                return null;
            }
        }
        if ((tl = lastTimeLeft.getReal() - nowTimeLeft.getReal()) < 0.0) {
            return null;
        }
        return new Double(tl);
    }

    private void updateInheritedDecoration() {
        if (this.previous_ == null) {
            this.inheritableDecoration_.clear();
        } else {
            this.inheritableDecoration_.set(this.previous_.inheritableDecoration_);
        }
        Property[] properties = this.node_.getProperties();
        int i = 0;
        while (i < properties.length) {
            this.inheritableDecoration_.set(properties[i]);
            ++i;
        }
    }

    public NodeEntity getPrevious() {
        return this.previous_;
    }

    public Node getNode() {
        return this.node_;
    }

    public NodeTree getNodeTree() {
        return this.nodeTree_;
    }

    public int getSelectedVariationIndex() {
        int curVariations = this.nodeTree_.getVariationSize();
        if (curVariations == 0) {
            this.selectedVariationIndex_ = -1;
        } else if (curVariations <= this.selectedVariationIndex_) {
            this.selectedVariationIndex_ = curVariations - 1;
        }
        return this.selectedVariationIndex_;
    }

    public IgoBoard getIgoBoard() {
        return this.nodeList_.updateIgoBoard(this);
    }

    public void update() {
        this.nodeList_.update(this);
    }

    public Stone getMove() {
        return this.move_;
    }

    public InheritableMarker getInheritableDecoration() {
        this.nodeList_.updateIgoBoard(this);
        return this.inheritableDecoration_;
    }

    public Stone[] getCaptured() {
        return this.capturedStones_.toArray(new Stone[this.capturedStones_.size()]);
    }

    public Stone[] getLastCaptured() {
        HashSet captured = new HashSet();
        captured.addAll(Arrays.asList(this.getCaptured()));
        NodeEntity previous = this.getPrevious();
        if (previous != null) {
            captured.removeAll((Collection)Arrays.asList(previous.getCaptured()));
        }
        return captured.toArray(new Stone[captured.size()]);
    }

    public NodeEntity[] getVariations() {
        GameTree[] children = this.nodeTree_.getChildren();
        NodeEntity[] ret = new NodeEntity[children.length];
        int i = 0;
        while (i < ret.length) {
            ret[i] = new NodeEntity(children[i].getSequence().getFirst(), children[i], this.nodeList_, this.previous_);
            ret[i].composeMove();
            ++i;
        }
        return ret;
    }

    public Set<SgfPoint> getInvalid() {
        return Collections.unmodifiableSet(this.invalidPoints_);
    }

    public NodeEntity findAbove(PropertyType propertyType) {
        ArgumentChecker.throwIfNull((Object)propertyType);
        NodeEntity entity = this;
        while (entity != null) {
            if (entity.getNode().contains(propertyType)) {
                return entity;
            }
            entity = entity.getPrevious();
        }
        return entity;
    }

    NodeView getNodeView() {
        if (this.nodeView_ == null) {
            this.nodeView_ = new NodeView(this);
        }
        return this.nodeView_;
    }

    public boolean appends(SgfId sgfId) {
        ArgumentChecker.throwIfNull((Object)sgfId);
        switch (sgfId.propertyType()) {
            case MOVE: {
                if (this.node_.getProperty(SgfId.WHITE) != null || this.node_.getProperty(SgfId.BLACK) != null) break;
                return false;
            }
            case ROOT: {
                if (this.nodeTree_.getRootGameTree().getSequence().getFirst() == this.node_) break;
                return false;
            }
            case SETUP: {
                if (!this.node_.contains(PropertyType.MOVE)) break;
                return false;
            }
        }
        GameType gameType = this.nodeTree_.getRootGameTree().getGameType();
        switch (gameType) {
            case GAME: {
                return true;
            }
            case PROBLEM: {
                if (!idSet4Problem_s_.contains(sgfId)) {
                    return false;
                }
                SgfColor color = BasicFinder.firstMove(this.nodeTree_.getRootGameTree());
                if (SgfId.GOOD_FOR_BLACK.equals(sgfId) && color != SgfColor.BLACK) {
                    return false;
                }
                return !SgfId.GOOD_FOR_WHITE.equals(sgfId) || color == SgfColor.WHITE;
            }
            case DRILL: {
                return idSet4Drill_s_.contains(sgfId);
            }
        }
        assert (false) : "Unknown GameType: " + gameType;
        log_s_.warn("Unknown GameType: " + gameType);
        return true;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        return this.node_ == ((NodeEntity)obj).node_;
    }

    public int hashCode() {
        return this.node_.hashCode();
    }
}

