/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.model;

import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.util.ArgumentChecker;

public class NodeTree {
    private final RootGameTree rootGameTree_;
    private final GameTree parentGameTree_;
    private final GameTree gameTree_;
    private final Node node_;

    public NodeTree(Node node, GameTree tree) {
        ArgumentChecker.throwIfNull((Object)node, (Object)tree);
        this.node_ = node;
        this.gameTree_ = tree;
        this.parentGameTree_ = this.gameTree_.getParent();
        GameTree p = tree;
        while (p.getParent() != null) {
            p = p.getParent();
        }
        assert (p instanceof RootGameTree) : "Root tree must be an instance of RootGameTree.";
        this.rootGameTree_ = (RootGameTree)p;
    }

    public GameTree getGameTree() {
        return this.gameTree_;
    }

    public GameTree getParentGameTree() {
        return this.parentGameTree_;
    }

    public RootGameTree getRootGameTree() {
        return this.rootGameTree_;
    }

    public boolean isChildrenStyle() {
        return this.rootGameTree_.getStyle().isChildrenStyle();
    }

    public SgfSize getSize() {
        return this.rootGameTree_.getSize();
    }

    public boolean isFirstNode() {
        return this.gameTree_.getSequence().getFirst() == this.node_;
    }

    public boolean isLastNode() {
        Node node = this.gameTree_.getSequence().getLast();
        return node == null ? true : node == this.node_;
    }

    private boolean hasChildVariation() {
        return this.rootGameTree_.getStyle().isChildrenStyle() && this.isLastNode();
    }

    private boolean hasSiblingVariation() {
        return !this.rootGameTree_.getStyle().isChildrenStyle() && this.isFirstNode() && this.parentGameTree_ != null;
    }

    public int getVariationSize() {
        return this.hasChildVariation() ? this.gameTree_.getChildrenSize() : (this.hasSiblingVariation() ? this.parentGameTree_.getChildrenSize() : 0);
    }

    /*
     * WARNING - void declaration
     */
    public GameTree[] getChildren() {
        void var1_1;
        GameTree[] children;
        if (this.hasChildVariation()) {
            children = this.gameTree_.getChildren();
        } else if (this.hasSiblingVariation()) {
            children = this.parentGameTree_.getChildren();
        } else {
            return new GameTree[0];
        }
        return var1_1;
    }
}

