/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.model;

import java.util.EnumSet;
import java.util.Set;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.PropertyType;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.SgfColor;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.util.SgfPointType;
import org.unitarou.sgf.util.Stone;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.model.NodeEntity;
import org.unitarou.yukinoshita.model.NodeTree;
import org.unitarou.yukinoshita.model.RootView;
import org.unitarou.yukinoshita.model.board.IgoBoard;
import org.unitarou.yukinoshita.model.board.IgoBoardView;
import org.unitarou.yukinoshita.model.board.InheritableMarker;
import org.unitarou.yukinoshita.model.board.OverblockMarker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NodeView {
    private final NodeEntity nodeEntity_;
    private final RootView rootView_;
    static /* synthetic */ Class class$0;

    public NodeView(NodeEntity nodeEntity) {
        ArgumentChecker.throwIfNull((Object)nodeEntity);
        this.nodeEntity_ = nodeEntity;
        this.rootView_ = new RootView(this.nodeEntity_.getNodeTree().getRootGameTree());
    }

    public RootView getRootView() {
        return this.rootView_;
    }

    public boolean isSameNodeEntity(NodeView nodeView) {
        ArgumentChecker.throwIfNull((Object)nodeView);
        return this.nodeEntity_.equals(nodeView.nodeEntity_);
    }

    public IgoBoardView getIgoBoard() {
        return this.nodeEntity_.getIgoBoard();
    }

    public InheritableMarker getInheritableDecoration() {
        return this.nodeEntity_.getInheritableDecoration();
    }

    public boolean containsPropertyType(PropertyType propertyType) {
        ArgumentChecker.throwIfNull((Object)propertyType);
        for (SgfId sgfId : this.nodeEntity_.getNode().getPropertyIds()) {
            if (sgfId.propertyType() != propertyType) continue;
            return true;
        }
        return false;
    }

    public int variationSize() {
        return this.nodeEntity_.getNodeTree().getVariationSize();
    }

    public NodeView[] getVariations() {
        NodeEntity[] mle = this.nodeEntity_.getVariations();
        NodeView[] ret = new NodeView[mle.length];
        int i = 0;
        while (i < ret.length) {
            ret[i] = mle[i].getNodeView();
            ++i;
        }
        return ret;
    }

    public Stone getMove() {
        return this.nodeEntity_.getMove();
    }

    public Property getProperty(SgfId id) {
        return this.nodeEntity_.getNode().getProperty(id);
    }

    public Property findProperty(SgfId sgfId) {
        ArgumentChecker.throwIfNull((Object)sgfId);
        NodeEntity neGameInfo_ = this.nodeEntity_.findAbove(sgfId.propertyType());
        if (neGameInfo_ == null) {
            return null;
        }
        return neGameInfo_.getNode().getProperty(sgfId);
    }

    public boolean isChildrenStyle() {
        return this.nodeEntity_.getNodeTree().isChildrenStyle();
    }

    public SgfColor getOppositeColor() {
        return this.isChildrenStyle() ? this.getNextMoveColor() : this.getMove().getColor();
    }

    public int getSelectedVariationIndex() {
        return this.nodeEntity_.getSelectedVariationIndex();
    }

    public int getVariationHash() {
        NodeEntity previous = this.nodeEntity_;
        int hash = -1;
        while (previous != null) {
            int index = previous.getSelectedVariationIndex();
            if (index != -1) {
                hash += index;
            }
            previous = previous.getPrevious();
        }
        return hash;
    }

    public OverblockMarker getOverblockMarker() {
        return new OverblockMarker(this.nodeEntity_.getNode());
    }

    public SgfSize getSize() {
        return this.nodeEntity_.getNodeTree().getSize();
    }

    public SgfColor getNextMoveColor() {
        NodeEntity entity = this.nodeEntity_;
        do {
            if (entity.getNode().contains(PropertyType.SETUP)) {
                Property property = entity.getNode().getProperty(SgfId.PLAYER_TO_PLAY);
                if (property != null) {
                    return SgfColor.parseQuietly(property.value().getString());
                }
                return null;
            }
            SgfColor curColor = entity.getMove().getColor();
            if (curColor == null) continue;
            return curColor.opposite();
        } while ((entity = entity.getPrevious()) != null);
        return null;
    }

    public boolean isFirst() {
        return this.nodeEntity_.getPrevious() == null;
    }

    public boolean isLast() {
        NodeTree nodeTree = this.nodeEntity_.getNodeTree();
        return nodeTree.getGameTree().getChildrenSize() == 0 && nodeTree.isLastNode();
    }

    public EnumSet<SgfPointType> getPointTypes(SgfPoint point) {
        ArgumentChecker.throwIfNull((Object)point);
        EnumSet<SgfPointType> ret = EnumSet.noneOf(SgfPointType.class);
        IgoBoard igoBoard = this.nodeEntity_.getIgoBoard();
        if (igoBoard == null) {
            ret.add(SgfPointType.FORBIDDEN);
            ret.add(SgfPointType.EMPTY);
            return ret;
        }
        Stone stone = igoBoard.getStone(point);
        if (stone == null) {
            ret.add(SgfPointType.EMPTY);
        } else if (SgfColor.BLACK.equals(stone.getColor())) {
            ret.add(SgfPointType.BLACK);
        } else if (SgfColor.WHITE.equals(stone.getColor())) {
            ret.add(SgfPointType.WHITE);
        } else assert (false) : "Known types are found:" + stone.getColor();
        Stone move = this.nodeEntity_.getMove();
        if (move.isValid() && igoBoard.isForbiddenMove(point, move.getColor().opposite(), move.getPoint(), this.nodeEntity_.getLastCaptured())) {
            ret.add(SgfPointType.FORBIDDEN);
        }
        return ret;
    }

    public SgfPointType getPointTypes4Variation(SgfPoint point) {
        ArgumentChecker.throwIfNull((Object)point);
        if (this.isChildrenStyle()) {
            EnumSet<SgfPointType> set = this.getPointTypes(point);
            return set.contains((Object)SgfPointType.FORBIDDEN) ? SgfPointType.FORBIDDEN : SgfPointType.EMPTY;
        }
        NodeEntity previous = this.nodeEntity_.getPrevious();
        if (previous == null || previous.getIgoBoard().getStone(point) != null) {
            return SgfPointType.FORBIDDEN;
        }
        if (!previous.getMove().isValid()) {
            return SgfPointType.EMPTY;
        }
        return previous.getIgoBoard().isForbiddenMove(point, previous.getMove().getColor().opposite(), previous.getMove().getPoint(), previous.getLastCaptured()) ? SgfPointType.FORBIDDEN : SgfPointType.EMPTY;
    }

    public Set<SgfPoint> getInvalid() {
        return this.nodeEntity_.getInvalid();
    }

    public boolean appends(SgfId sgfId) {
        return this.nodeEntity_.appends(sgfId);
    }
}

