/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.model.board;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.unitarou.lang.NullArgumentException;
import org.unitarou.lang.UEnum;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.PropertyType;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.ValueType;
import org.unitarou.sgf.type.Label;
import org.unitarou.sgf.type.SgfLine;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.util.SgfRectangle;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.model.board.IgoBoard;
import org.unitarou.yukinoshita.model.board.InheritableMarker;
import org.unitarou.yukinoshita.model.board.OverblockMarker;
import org.unitarou.yukinoshita.view.jface.board.BlockPainter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockedBoardDesigner {
    private static final SgfId[] drawTypes_s_ = new SgfId[]{SgfId.MARK_WITH_X, SgfId.CIRCLE, SgfId.SQUARE, SgfId.TRIANGLE, SgfId.SELECTED, SgfId.TERRITORY_WHITE, SgfId.TERRITORY_BLACK, SgfId.DIM_POINTS};
    private final Map<SgfPoint, Set<SgfId>> markerMap_ = new TreeMap<SgfPoint, Set<SgfId>>();
    private final InheritableMarker inheritableMarker_ = new InheritableMarker();
    private final OverblockMarker overblockMarker_ = new OverblockMarker();
    private final List<BlockPainter> blockPainters_ = new ArrayList<BlockPainter>();
    private NodeView nodeView_ = null;
    private final Set<SgfPoint> durablePaintings_ = new TreeSet<SgfPoint>();
    private final Set<SgfPoint> transientPaintings_ = new TreeSet<SgfPoint>();
    private final Set<SgfPoint> lastTransientPaintings_ = new TreeSet<SgfPoint>();
    private final Set<SgfPoint> vwPoints_ = new TreeSet<SgfPoint>();
    static /* synthetic */ Class class$0;

    public BlockedBoardDesigner(IgoBoard igoBoard) {
    }

    public void addBlockPainter(BlockPainter blockPainter) {
        ArgumentChecker.throwIfNull((Object)blockPainter);
        this.blockPainters_.add(blockPainter);
    }

    public void removeBlockPainter(BlockPainter blockPainter) {
        ArgumentChecker.throwIfNull((Object)blockPainter);
        this.blockPainters_.remove(blockPainter);
    }

    private void addMarker(SgfPoint point, SgfId sgfType) {
        ArgumentChecker.throwIfNull((Object)point, (Object)sgfType);
        Set<SgfId> markerSet = this.markerMap_.get(point);
        if (markerSet == null) {
            markerSet = new TreeSet<SgfId>();
            this.markerMap_.put(point, markerSet);
        }
        markerSet.add(sgfType);
    }

    public void addRedrawPoint(SgfPoint point) {
        ArgumentChecker.throwIfNull((Object)point);
        this.transientPaintings_.add(point);
    }

    public SgfId[] getMarkers(SgfPoint point) {
        ArgumentChecker.throwIfNull((Object)point);
        Set<SgfId> markerSet = this.markerMap_.get(point);
        if (markerSet == null) {
            return new SgfId[0];
        }
        return markerSet.toArray(new SgfId[markerSet.size()]);
    }

    public SgfPoint[] getMarkerPoints(SgfId sgfType) {
        if (sgfType == null) {
            throw new NullArgumentException("sgfType must not be null.");
        }
        ArrayList<SgfPoint> ret = new ArrayList<SgfPoint>(this.markerMap_.size());
        for (Map.Entry<SgfPoint, Set<SgfId>> entry : this.markerMap_.entrySet()) {
            Set<SgfId> markers = entry.getValue();
            if (markers == null || !markers.contains(sgfType)) continue;
            ret.add(entry.getKey());
        }
        return ret.toArray(new SgfPoint[ret.size()]);
    }

    public boolean hasOverblockMark() {
        return !this.overblockMarker_.isEmpty();
    }

    public void update(NodeView newNodeView) {
        ArgumentChecker.throwIfNull((Object)newNodeView);
        this.nodeView_ = newNodeView;
        this.markerMap_.clear();
        this.durablePaintings_.clear();
        this.lastTransientPaintings_.clear();
        this.lastTransientPaintings_.addAll(this.transientPaintings_);
        this.transientPaintings_.clear();
        for (BlockPainter blockPainter : this.blockPainters_) {
            Set<SgfPoint> set = blockPainter.getDurablePaintings(newNodeView);
            if (set == null) continue;
            this.durablePaintings_.addAll(set);
            this.transientPaintings_.addAll(blockPainter.getTransientPaintings(this.nodeView_));
        }
        this.updateMarkers(newNodeView);
        this.updateInheritableMarkers(newNodeView.getInheritableDecoration());
        this.updateOverblockMarker(newNodeView);
    }

    private void updateMarkers(NodeView nodeView) {
        int i = 0;
        while (i < drawTypes_s_.length) {
            Property property = nodeView.getProperty(drawTypes_s_[i]);
            if (property != null && property.sgfId().valueType().equals((Object)ValueType.POINT)) {
                String[] values = property.value().getStrings();
                SgfPoint[] points = SgfPoint.parse(this.nodeView_.getSize(), values);
                int j = 0;
                while (j < points.length) {
                    this.addMarker(points[j], drawTypes_s_[i]);
                    ++j;
                }
            }
            ++i;
        }
    }

    private void updateInheritableMarkers(InheritableMarker inheritableMarker) {
        UEnum[] enums = UEnum.getAll(SgfId.class);
        int i = 0;
        while (i < enums.length) {
            SgfId sgfId = (SgfId)enums[i];
            if (sgfId.propertyType().equals(PropertyType.INHERIT)) {
                if (SgfId.VIEW.equals(sgfId)) {
                    this.updateInheritableMarkerImpl4VW(inheritableMarker);
                } else {
                    this.updateInheritableMarkerImpl(inheritableMarker, sgfId);
                }
            }
            ++i;
        }
        this.inheritableMarker_.set(inheritableMarker);
    }

    private void updateInheritableMarkerImpl(InheritableMarker inheritable, SgfId sgfType) {
        int i;
        String[] oldValues = this.inheritableMarker_.get(sgfType);
        String[] newValues = inheritable.get(sgfType);
        SgfPoint[] oldPoints = this.getPoints(oldValues);
        SgfPoint[] newPoints = this.getPoints(newValues);
        if (oldPoints != null) {
            i = 0;
            while (i < oldPoints.length) {
                this.addRedrawPoint(oldPoints[i]);
                ++i;
            }
        }
        if (newPoints == null) {
            return;
        }
        i = 0;
        while (i < newPoints.length) {
            this.addMarker(newPoints[i], sgfType);
            ++i;
        }
    }

    private void updateInheritableMarkerImpl4VW(InheritableMarker inheritable) {
        String[] oldValues = this.inheritableMarker_.get(SgfId.VIEW);
        String[] newValues = inheritable.get(SgfId.VIEW);
        SgfPoint[] oldPoints = this.getPoints(oldValues);
        SgfPoint[] newPoints = this.getPoints(newValues);
        this.vwPoints_.clear();
        if (oldPoints == null && newPoints == null) {
            this.vwPoints_.addAll(this.nodeView_.getSize().all());
            return;
        }
        if (oldPoints == null || oldPoints.length == 0) {
            Set<SgfPoint> all = this.nodeView_.getSize().all();
            oldPoints = all.toArray(new SgfPoint[all.size()]);
        }
        int i = 0;
        while (i < oldPoints.length) {
            this.addRedrawPoint(oldPoints[i]);
            ++i;
        }
        if (newPoints == null || newPoints.length == 0) {
            this.vwPoints_.addAll(this.nodeView_.getSize().all());
            newPoints = this.vwPoints_.toArray(new SgfPoint[this.vwPoints_.size()]);
        }
        SgfPoint[] sgfPointArray = newPoints;
        int n = 0;
        int n2 = sgfPointArray.length;
        while (n < n2) {
            SgfPoint sgfPoint = sgfPointArray[n];
            this.addMarker(sgfPoint, SgfId.VIEW);
            this.addRedrawPoint(sgfPoint);
            this.vwPoints_.add(sgfPoint);
            ++n;
        }
    }

    private SgfPoint[] getPoints(String[] values) {
        return values == null ? null : SgfPoint.parse(this.nodeView_.getSize(), values);
    }

    private void updateOverblockMarker(NodeView nodeView) {
        OverblockMarker newMarker = nodeView.getOverblockMarker();
        boolean isEmpty = this.overblockMarker_.isEmpty() && newMarker.isEmpty();
        this.overblockMarker_.set(newMarker);
        if (isEmpty) {
            return;
        }
    }

    public SgfRectangle calcView() {
        SgfRectangle ret = new SgfRectangle();
        SgfPoint[] points = this.vwPoints_.toArray(new SgfPoint[this.vwPoints_.size()]);
        int i = 0;
        while (i < points.length) {
            ret.intersect(points[i]);
            ++i;
        }
        if (points.length == 0) {
            SgfSize size = this.nodeView_.getSize();
            ret.set(SgfPoint.create(size, 1, 1), SgfPoint.create(size, size.width(), size.height()));
        }
        return ret;
    }

    public boolean isDrawArea(SgfPoint point) {
        return this.vwPoints_.contains(point);
    }

    public Set<SgfPoint> getRedrawBlocks() {
        TreeSet<SgfPoint> allPoints = new TreeSet<SgfPoint>();
        allPoints.addAll(this.durablePaintings_);
        allPoints.addAll(this.transientPaintings_);
        allPoints.addAll(this.lastTransientPaintings_);
        return allPoints;
    }

    public Label[] getLabels() {
        return this.overblockMarker_.getLabels(this.nodeView_.getSize());
    }

    public SgfLine[] getLine(SgfId sgfType) {
        return this.overblockMarker_.getLine(sgfType, this.nodeView_.getSize());
    }
}

