/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.model.board;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitarou.lang.ForStackTraceException;
import org.unitarou.sgf.type.SgfColor;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.util.BasicFormatter;
import org.unitarou.sgf.util.SgfPointType;
import org.unitarou.sgf.util.Stone;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.model.board.IgoBoardView;
import org.unitarou.yukinoshita.model.board.StoneGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IgoBoard
implements IgoBoardView {
    private static final Log log_s_ = LogFactory.getLog(IgoBoard.class);
    private SgfSize size_;
    private final Set<StoneGroup> blackGroups_;
    private final Set<StoneGroup> whiteGroups_;
    private final Map<SgfPoint, Stone> allStones_;
    private final List<Stone> captured_;
    private ForStackTraceException stackTraceOfConstructor_;
    static /* synthetic */ Class class$0;

    public IgoBoard(SgfSize size) {
        ArgumentChecker.throwIfNull((Object)size);
        this.size_ = size;
        this.blackGroups_ = new HashSet<StoneGroup>(2);
        this.whiteGroups_ = new HashSet<StoneGroup>(2);
        this.allStones_ = new TreeMap<SgfPoint, Stone>();
        this.captured_ = new ArrayList<Stone>(0);
        if (log_s_.isDebugEnabled()) {
            this.stackTraceOfConstructor_ = new ForStackTraceException();
            this.stackTraceOfConstructor_.fillInStackTrace();
        }
    }

    public void dispose() {
        this.allStones_.clear();
    }

    public void setCaptured(List<Stone> captured) {
        ArgumentChecker.throwIfNull(captured);
        this.captured_.clear();
        this.captured_.addAll(captured);
    }

    public void removeCaptured(List<Stone> capturedStones) {
        ArgumentChecker.throwIfNull(capturedStones);
        if (!log_s_.isDebugEnabled()) {
            this.captured_.removeAll(capturedStones);
            return;
        }
        for (Stone stone : capturedStones) {
            if (!this.captured_.remove(stone)) assert (false);
        }
    }

    public void setSize(SgfSize size) {
        ArgumentChecker.throwIfNull((Object)size);
        if (this.size_.equals(size)) {
            return;
        }
        this.size_ = size;
    }

    @Deprecated
    public Stone[] moveStone(SgfColor color, SgfPoint point) {
        return this.moveStone(new Stone(color, point, null));
    }

    public Stone[] moveStone(Stone stone) {
        ArgumentChecker.throwIfNull((Object)stone);
        SgfPoint point = stone.getPoint();
        SgfColor color = stone.getColor();
        this.setStone(stone);
        if (point.condition() == SgfPointType.PASS) {
            return Stone.EMPTY_ARRAY;
        }
        return this.removeDeadStone(color.opposite());
    }

    @Deprecated
    public void setStone(SgfColor color, SgfPoint point) {
        this.setStone(new Stone(color, point, null));
    }

    public void setStone(Stone stone) {
        ArgumentChecker.throwIfNull((Object)stone);
        SgfPoint point = stone.getPoint();
        SgfColor color = stone.getColor();
        ArgumentChecker.throwIfNull((Object)point, (Object)color);
        if (point.condition() == SgfPointType.OUT) {
            throw new IllegalArgumentException("Bad point:" + point);
        }
        if (point.condition() == SgfPointType.PASS) {
            return;
        }
        Collection<SgfPoint> lifePoints = this.findLifePoints(point);
        Set<StoneGroup> target = this.getStoneGroups(color);
        if (!this.appendStone(target, point, lifePoints)) {
            StoneGroup newGroup = new StoneGroup(this.size_);
            newGroup.add(point, lifePoints);
            target.add(newGroup);
        }
        this.allStones_.put(point, stone);
        for (StoneGroup stoneGroup : this.getStoneGroups(color.opposite())) {
            stoneGroup.removeLifePoint(point);
        }
    }

    private Set<StoneGroup> getStoneGroups(SgfColor color) {
        return color == SgfColor.BLACK ? this.blackGroups_ : this.whiteGroups_;
    }

    private boolean appendStone(Collection<StoneGroup> groups, SgfPoint point, Collection<SgfPoint> lifePoints) {
        assert (groups != null && point != null && lifePoints != null);
        ArrayList<StoneGroup> targetGroups = new ArrayList<StoneGroup>(4);
        for (StoneGroup stoneGroup : groups) {
            if (!stoneGroup.isLifePoint(point)) continue;
            targetGroups.add(stoneGroup);
        }
        if (targetGroups.isEmpty()) {
            return false;
        }
        Iterator ipt = targetGroups.iterator();
        StoneGroup target = (StoneGroup)ipt.next();
        target.add(point, lifePoints);
        while (ipt.hasNext()) {
            StoneGroup src = (StoneGroup)ipt.next();
            target.add(src);
            groups.remove(src);
        }
        return true;
    }

    public SgfColor removeStone(SgfPoint point) {
        StoneGroup group;
        this.allStones_.remove(point);
        Iterator<StoneGroup> ip = this.blackGroups_.iterator();
        while (ip.hasNext()) {
            group = ip.next();
            if (!group.contains(point)) continue;
            StoneGroup[] groups = group.remove(point);
            if (group.count() == 0) {
                ip.remove();
            }
            int i = 1;
            while (i < groups.length) {
                this.blackGroups_.add(groups[i]);
                ++i;
            }
            Set<StoneGroup> opposite = this.whiteGroups_;
            for (StoneGroup group2 : opposite) {
                group2.addLifePoint(point);
            }
            return SgfColor.BLACK;
        }
        ip = this.whiteGroups_.iterator();
        while (ip.hasNext()) {
            group = ip.next();
            if (!group.contains(point)) continue;
            StoneGroup[] groups = group.remove(point);
            if (group.count() == 0) {
                ip.remove();
            }
            int i = 1;
            while (i < groups.length) {
                this.whiteGroups_.add(groups[i]);
                ++i;
            }
            Set<StoneGroup> opposite = this.blackGroups_;
            for (StoneGroup group2 : opposite) {
                group2.addLifePoint(point);
            }
            return SgfColor.WHITE;
        }
        return null;
    }

    private Stone[] removeDeadStone(SgfColor color) {
        Set<StoneGroup> target = this.getStoneGroups(color);
        Set<StoneGroup> opposite = this.getStoneGroups(color.opposite());
        HashSet<SgfPoint> deadStones = new HashSet<SgfPoint>();
        Iterator ip = target.iterator();
        while (ip.hasNext()) {
            StoneGroup group = (StoneGroup)ip.next();
            if (group.countLifePoint() != 0) continue;
            ip.remove();
            deadStones.addAll(group.stones());
        }
        for (StoneGroup stoneGroup : opposite) {
            for (SgfPoint sgfPoint : deadStones) {
                stoneGroup.addLifePoint(sgfPoint);
            }
        }
        Stone[] ret = new Stone[deadStones.size()];
        int index = 0;
        for (SgfPoint sgfPoint : deadStones) {
            Stone stone = this.allStones_.get(sgfPoint);
            if (stone != null) {
                this.captured_.add(stone);
                ret[index] = this.allStones_.get(sgfPoint);
                this.allStones_.remove(sgfPoint);
            } else assert (false) : "Not found stone " + sgfPoint + " in " + BasicFormatter.format((Collection<SgfPoint>)this.allStones_.keySet());
            ++index;
        }
        return ret;
    }

    @Override
    public boolean isForbiddenMove(SgfPoint point, SgfColor color, SgfPoint lastMove, Stone[] lastCaptured) {
        ArgumentChecker.throwIfNull((Object)point, (Object)color, (Object)lastMove, (Object)lastCaptured);
        if (!this.isEmpty(point)) {
            return true;
        }
        Set<StoneGroup> opposite = this.getStoneGroups(color.opposite());
        for (StoneGroup stoneGroup : opposite) {
            if (stoneGroup.countLifePoint() != 1 || !stoneGroup.isLifePoint(point)) continue;
            return this.isKoViolation(stoneGroup, point, lastMove, lastCaptured);
        }
        int lifePoint = this.findLifePoints(point).size();
        if (lifePoint != 0) {
            return false;
        }
        Set<StoneGroup> friend = this.getStoneGroups(color);
        for (StoneGroup stoneGroup : friend) {
            if (!stoneGroup.isLifePoint(point) || (lifePoint += stoneGroup.countLifePoint() - 1) == 0) continue;
            return false;
        }
        return lifePoint == 0;
    }

    @Override
    public SortedMap<SgfPoint, SgfColor> diff(IgoBoard src) {
        ArgumentChecker.throwIfNull((Object)src);
        if (!this.size_.equals(src.size_)) {
            throw new IllegalArgumentException("Bad size: " + this.size_ + "!=" + src.size_);
        }
        TreeMap<SgfPoint, SgfColor> ret = new TreeMap<SgfPoint, SgfColor>();
        this.diff(SgfColor.BLACK, src.blackGroups_, this.blackGroups_, ret);
        this.diff(SgfColor.WHITE, src.whiteGroups_, this.whiteGroups_, ret);
        return ret;
    }

    private void diff(SgfColor color, Collection<StoneGroup> srcGroups, Collection<StoneGroup> desGroups, SortedMap<SgfPoint, SgfColor> diffMap) {
        TreeSet<SgfPoint> srcStones = new TreeSet<SgfPoint>();
        for (StoneGroup stoneGroup : srcGroups) {
            srcStones.addAll(stoneGroup.stones());
        }
        TreeSet<SgfPoint> desStones = new TreeSet<SgfPoint>();
        for (StoneGroup stoneGroup : desGroups) {
            desStones.addAll(stoneGroup.stones());
        }
        Iterator sip = srcStones.iterator();
        Iterator dip = desStones.iterator();
        block2: while (sip.hasNext() || dip.hasNext()) {
            if (!sip.hasNext()) {
                while (dip.hasNext()) {
                    diffMap.put((SgfPoint)dip.next(), color);
                }
                continue;
            }
            if (!dip.hasNext()) {
                while (sip.hasNext()) {
                    this.putNull(diffMap, (SgfPoint)sip.next());
                }
                continue;
            }
            SgfPoint sp = (SgfPoint)sip.next();
            SgfPoint dp = (SgfPoint)dip.next();
            while (true) {
                int compared;
                if ((compared = sp.compareTo(dp)) < 0) {
                    this.putNull(diffMap, sp);
                    if (!sip.hasNext()) {
                        diffMap.put(dp, color);
                        while (dip.hasNext()) {
                            diffMap.put((SgfPoint)dip.next(), color);
                        }
                        continue block2;
                    }
                    sp = (SgfPoint)sip.next();
                    continue;
                }
                if (compared <= 0) continue block2;
                diffMap.put(dp, color);
                if (!dip.hasNext()) {
                    this.putNull(diffMap, sp);
                    while (sip.hasNext()) {
                        this.putNull(diffMap, (SgfPoint)sip.next());
                    }
                    continue block2;
                }
                dp = (SgfPoint)dip.next();
            }
        }
    }

    private void putNull(Map<SgfPoint, SgfColor> map, SgfPoint key) {
        if (!map.containsKey(key)) {
            map.put(key, null);
        }
    }

    private boolean isKoViolation(StoneGroup group, SgfPoint move, SgfPoint lastMove, Stone[] lastCaptured) {
        assert (group != null && move != null && lastMove != null && lastCaptured != null);
        return lastCaptured.length == 1 && move.equals(lastCaptured[0].getPoint()) && group.count() == 1 && group.stones().contains(lastMove);
    }

    private Collection<SgfPoint> findLifePoints(SgfPoint point) {
        assert (point != null);
        ArrayList<SgfPoint> lifePoints = new ArrayList<SgfPoint>(4);
        for (SgfPoint sgfPoint : point.neighbors()) {
            if (!this.isEmpty(sgfPoint)) continue;
            lifePoints.add(sgfPoint);
        }
        return lifePoints;
    }

    private boolean isEmpty(SgfPoint point) {
        assert (point != null);
        return !this.allStones_.containsKey(point);
    }

    @Override
    public SortedSet<SgfPoint> position(SgfColor color) {
        ArgumentChecker.throwIfNull((Object)color);
        TreeSet<SgfPoint> stones = new TreeSet<SgfPoint>();
        Set<StoneGroup> stoneGroups = this.getStoneGroups(color);
        for (StoneGroup stoneGroup : stoneGroups) {
            stones.addAll(stoneGroup.stones());
        }
        return stones;
    }

    @Override
    public SgfSize size() {
        return this.size_;
    }

    @Override
    public List<Stone> getCaptured(SgfColor playerColor) {
        ArgumentChecker.throwIfNull((Object)playerColor);
        ArrayList<Stone> ret = new ArrayList<Stone>(this.captured_.size());
        for (Stone stone : this.captured_) {
            if (!playerColor.opposite().equals(stone.getColor())) continue;
            ret.add(stone);
        }
        return ret;
    }

    @Override
    public List<Stone> getCaptured() {
        return Collections.unmodifiableList(this.captured_);
    }

    @Override
    public Stone getStone(SgfPoint point) {
        ArgumentChecker.throwIfNull((Object)point);
        return this.allStones_.get(point);
    }

    @Override
    public int lifePoint(SgfPoint point) {
        ArgumentChecker.throwIfNull((Object)point);
        for (StoneGroup stoneGroup : this.blackGroups_) {
            if (!stoneGroup.contains(point)) continue;
            return stoneGroup.countLifePoint();
        }
        for (StoneGroup stoneGroup : this.whiteGroups_) {
            if (!stoneGroup.contains(point)) continue;
            return stoneGroup.countLifePoint();
        }
        return -1;
    }

    @Override
    public Set<SgfPoint> validate() {
        HashSet<SgfPoint> ret = new HashSet<SgfPoint>();
        HashSet<SgfPoint> all = new HashSet<SgfPoint>();
        ret.addAll(this.validateImpl(this.blackGroups_, all));
        ret.addAll(this.validateImpl(this.whiteGroups_, all));
        return ret;
    }

    private Set<SgfPoint> validateImpl(Set<StoneGroup> stoneGroups, Set<SgfPoint> all) {
        HashSet<SgfPoint> ret = new HashSet<SgfPoint>();
        for (StoneGroup stoneGroup : stoneGroups) {
            for (SgfPoint sgfPoint : stoneGroup.stones()) {
                if (all.contains(sgfPoint)) {
                    ret.add(sgfPoint);
                    continue;
                }
                all.add(sgfPoint);
            }
        }
        return ret;
    }
}

