/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.model.board;

import java.util.SortedMap;
import java.util.TreeMap;
import org.unitarou.lang.NullArgumentException;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.PropertyType;
import org.unitarou.sgf.SgfId;

public class InheritableMarker {
    private final SortedMap<SgfId, String[]> inheritablePropertyMap_ = new TreeMap<SgfId, String[]>();

    public void set(Property property) {
        if (property == null) {
            return;
        }
        SgfId sgfType = property.sgfId();
        if (!sgfType.propertyType().equals(PropertyType.INHERIT)) {
            return;
        }
        this.inheritablePropertyMap_.remove(property.sgfId());
        this.inheritablePropertyMap_.put(sgfType, property.value().getStrings());
    }

    public void set(InheritableMarker inheritableDecoration) {
        if (inheritableDecoration == null) {
            throw new NullArgumentException("inheritableDecoration must not be null");
        }
        this.inheritablePropertyMap_.clear();
        this.inheritablePropertyMap_.putAll(inheritableDecoration.inheritablePropertyMap_);
    }

    public void clear() {
        this.inheritablePropertyMap_.clear();
    }

    public String[] get(SgfId type) {
        if (type == null) {
            throw new NullArgumentException("type must not be null");
        }
        String[] ret = (String[])this.inheritablePropertyMap_.get(type);
        return this.isEmptyValue(ret) ? null : ret;
    }

    private boolean isEmptyValue(String[] values) {
        return values == null || values.length == 0 || values.length == 1 && values[0].equals("");
    }
}

