/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.model.board;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.ValueType;
import org.unitarou.sgf.type.Label;
import org.unitarou.sgf.type.SgfLine;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.type.TypeParseException;
import org.unitarou.util.ArgumentChecker;

public class OverblockMarker {
    private static final Set<SgfId> targetTypeSet_s_ = new TreeSet<SgfId>();
    private final Map<SgfId, Set<String>> typeValueMap_;

    static {
        targetTypeSet_s_.add(SgfId.LABEL);
        targetTypeSet_s_.add(SgfId.LINE);
        targetTypeSet_s_.add(SgfId.ARROW);
    }

    public OverblockMarker() {
        this.typeValueMap_ = new TreeMap<SgfId, Set<String>>();
    }

    public OverblockMarker(Node node) {
        ArgumentChecker.throwIfNull((Object)node);
        this.typeValueMap_ = new TreeMap<SgfId, Set<String>>();
        Property[] propertyArray = node.getProperties();
        int n = 0;
        int n2 = propertyArray.length;
        while (n < n2) {
            Property property = propertyArray[n];
            this.setImpl(property);
            ++n;
        }
    }

    public void set(Property property) {
        this.setImpl(property);
    }

    private void setImpl(Property property) {
        if (property == null) {
            return;
        }
        SgfId sgfType = property.sgfId();
        if (!targetTypeSet_s_.contains(sgfType)) {
            return;
        }
        Set<String> valueSet = this.typeValueMap_.get(sgfType);
        if (valueSet != null) {
            valueSet.clear();
        } else {
            valueSet = new TreeSet<String>();
            this.typeValueMap_.put(sgfType, valueSet);
        }
        valueSet.addAll((Collection<String>)Arrays.asList(property.value().getStrings()));
    }

    public void set(OverblockMarker overblockMarker) {
        ArgumentChecker.throwIfNull((Object)overblockMarker);
        this.typeValueMap_.clear();
        this.typeValueMap_.putAll(overblockMarker.typeValueMap_);
    }

    public String[] get(SgfId sgfType) {
        ArgumentChecker.throwIfNull((Object)sgfType);
        Set<String> dataSet = this.typeValueMap_.get(sgfType);
        if (dataSet == null) {
            return new String[0];
        }
        return dataSet.toArray(new String[dataSet.size()]);
    }

    public Label[] getLabels(SgfSize size) {
        ArgumentChecker.throwIfNull((Object)size);
        String[] data = this.get(SgfId.LABEL);
        ArrayList<Label> labelList = new ArrayList<Label>(data.length);
        int i = 0;
        while (i < data.length) {
            Label label = Label.parseQuietly(size, data[i]);
            if (label != null) {
                labelList.add(label);
            }
            ++i;
        }
        return labelList.toArray(new Label[labelList.size()]);
    }

    public SgfLine[] getLine(SgfId sgfType, SgfSize size) {
        ArgumentChecker.throwIfNull((Object)sgfType, (Object)size);
        if (!sgfType.valueType().equals((Object)ValueType.CPOINT)) {
            throw new IllegalArgumentException("Bad type for getLine():" + sgfType);
        }
        String[] data = this.get(sgfType);
        ArrayList<SgfLine> lineList = new ArrayList<SgfLine>(data.length);
        int i = 0;
        while (i < data.length) {
            try {
                lineList.add(SgfLine.parse(size, data[i]));
            }
            catch (TypeParseException ignore) {
                ignore.printStackTrace();
            }
            ++i;
        }
        return lineList.toArray(new SgfLine[lineList.size()]);
    }

    public boolean isEmpty() {
        for (Set<String> dataSet : this.typeValueMap_.values()) {
            if (dataSet.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public void clear() {
        this.typeValueMap_.clear();
    }
}

