/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.model.board;

import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import org.unitarou.lang.NullArgumentException;
import org.unitarou.sgf.type.SgfColor;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.util.SgfPointType;
import org.unitarou.yukinoshita.model.board.IgoBoardView;

public class TextViewer {
    private final CharMap charMap_ = new CharMap(CharMap.DEFAULT_CHARMAP);

    public void setCharacter(SgfPointType type, char c) {
        if (type == null) {
            throw new NullArgumentException();
        }
        this.charMap_.put(type, c);
    }

    public String[] write(IgoBoardView goBoard) {
        SgfSize size = goBoard.size();
        String[] ret = new String[size.height()];
        SortedSet<SgfPoint> blackStones = goBoard.position(SgfColor.BLACK);
        SortedSet<SgfPoint> whiteStones = goBoard.position(SgfColor.WHITE);
        int y = 1;
        while (y <= size.height()) {
            ret[y - 1] = this.writeOneLine(size, y, blackStones, whiteStones);
            ++y;
        }
        return ret;
    }

    private String writeOneLine(SgfSize size, int y, SortedSet blackStones, SortedSet whiteStones) {
        StringBuilder sb = new StringBuilder();
        int x = 1;
        while (x <= size.width()) {
            SgfPoint point = SgfPoint.create(size, x, y);
            if (blackStones.contains(point)) {
                sb.append(this.charMap_.getChar(SgfPointType.BLACK));
            } else if (whiteStones.contains(point)) {
                sb.append(this.charMap_.getChar(SgfPointType.WHITE));
            } else if (size.isStarPoint(point)) {
                sb.append(this.charMap_.getChar(SgfPointType.STAR));
            } else {
                sb.append(this.charMap_.getChar(SgfPointType.classify(point)));
            }
            ++x;
        }
        return sb.toString();
    }

    public char getCharacter(SgfPointType pointType) {
        return this.charMap_.getChar(pointType);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class CharMap {
        public static final CharMap DEFAULT_CHARMAP;
        public static final CharMap NO_BOLD_CHARMAP;
        private final SortedMap<SgfPointType, Character> charMap_;

        static {
            TreeMap<SgfPointType, Character> map = new TreeMap<SgfPointType, Character>();
            map.put(SgfPointType.BLACK, new Character('\u25cf'));
            map.put(SgfPointType.WHITE, new Character('\u25cb'));
            map.put(SgfPointType.EMPTY, new Character('\u253c'));
            map.put(SgfPointType.TOP_LEFT, new Character('\u250f'));
            map.put(SgfPointType.TOP, new Character('\u252f'));
            map.put(SgfPointType.TOP_RIGHT, new Character('\u2513'));
            map.put(SgfPointType.LEFT, new Character('\u2520'));
            map.put(SgfPointType.RIGHT, new Character('\u2528'));
            map.put(SgfPointType.BOTTOM_LEFT, new Character('\u2517'));
            map.put(SgfPointType.BOTTOM, new Character('\u2537'));
            map.put(SgfPointType.BOTTOM_RIGHT, new Character('\u251b'));
            map.put(SgfPointType.STAR, new Character('\u254b'));
            DEFAULT_CHARMAP = new CharMap(map);
            map.put(SgfPointType.TOP_LEFT, new Character('\u250c'));
            map.put(SgfPointType.TOP, new Character('\u252c'));
            map.put(SgfPointType.TOP_RIGHT, new Character('\u2510'));
            map.put(SgfPointType.LEFT, new Character('\u251c'));
            map.put(SgfPointType.RIGHT, new Character('\u2524'));
            map.put(SgfPointType.BOTTOM_LEFT, new Character('\u2514'));
            map.put(SgfPointType.BOTTOM, new Character('\u2534'));
            map.put(SgfPointType.BOTTOM_RIGHT, new Character('\u2518'));
            map.put(SgfPointType.STAR, new Character('\u253c'));
            NO_BOLD_CHARMAP = new CharMap(map);
        }

        private CharMap(SortedMap<SgfPointType, Character> charMap) {
            this.charMap_ = new TreeMap<SgfPointType, Character>(charMap);
        }

        public CharMap(CharMap charMap) {
            this.charMap_ = new TreeMap<SgfPointType, Character>(charMap.charMap_);
        }

        public char getChar(SgfPointType type) {
            return ((Character)this.charMap_.get((Object)type)).charValue();
        }

        public void put(SgfPointType type, char c) {
            if (type == null) {
                throw new NullArgumentException();
            }
            this.charMap_.put(type, new Character(c));
        }
    }
}

