/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.model.cmd;

import java.util.EnumSet;
import java.util.LinkedList;
import org.unitarou.cmd.Command;
import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.cmd.CreateGameTree;
import org.unitarou.sgf.type.SgfColor;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.util.Stone;
import org.unitarou.sgf.util.provider.crdlp.CoordinatesLabelProvider;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.model.EditableNodeList;
import org.unitarou.yukinoshita.model.NodeEntity;
import org.unitarou.yukinoshita.model.cmd.Command4NodeList;
import org.unitarou.yukinoshita.model.cmd.ModelInfluence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddVariation
extends Command4NodeList {
    private static final MessageResource LB_NAME = new MessageResource(AddVariation.class, "lbName");
    private static final MessageResource LB_NO_MOVE = new MessageResource(AddVariation.class, "lbNoMove");
    private final GameTree newTree_;
    private LinkedList<NodeEntity> lastChain_;
    private NodeEntity baseEntity_;
    private Command sgfCommand_;
    private EnumSet<ModelInfluence> influences_;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public AddVariation(SgfColor color, SgfPoint point) {
        ArgumentChecker.throwIfNull((Object)color, (Object)point);
        Node node = Node.makeMoveNode(color, point);
        GameTree newTree = new GameTree();
        newTree.getSequence().addFirst(node);
        this.newTree_ = newTree;
        this.baseEntity_ = null;
        this.sgfCommand_ = null;
        this.influences_ = null;
    }

    @Override
    protected boolean setup() {
        if (this.sgfCommand_ != null) {
            return true;
        }
        EditableNodeList nodeList_ = this.getEditableNodeList();
        if (nodeList_ == null) {
            return false;
        }
        this.baseEntity_ = nodeList_.getPosition();
        this.lastChain_ = new LinkedList();
        this.sgfCommand_ = new CreateGameTree(this.baseEntity_.getNodeTree().getGameTree(), this.baseEntity_.getNode(), this.newTree_);
        this.influences_ = this.baseEntity_.getNodeTree().isChildrenStyle() ? EnumSet.of(ModelInfluence.NODE_PEVIOUS) : EnumSet.of(ModelInfluence.NODE_CURRENT);
        this.setExecutedNodeIndex(nodeList_.getPositionIndex() + 1);
        this.setUndoneNodeIndex(nodeList_.getPositionIndex() + 1);
        return true;
    }

    @Override
    public String displayName() {
        this.composeDisplayName();
        return super.displayName();
    }

    private void composeDisplayName() {
        this.setDisplayName(LB_NAME.get((Object)LB_NO_MOVE.get()));
        if (this.newTree_.getSequence().size() == 0 || !this.setup()) {
            return;
        }
        Stone stone = Stone.create(this.newTree_.getSequence().getFirst(), this.getEditableNodeList().getSize());
        if (!stone.isValid()) {
            return;
        }
        CoordinatesLabelProvider provider = Yukinoshita.context().getProvider(CoordinatesLabelProvider.class, this.baseEntity_.getNodeTree().getRootGameTree());
        this.setDisplayName(LB_NAME.get((Object)(String.valueOf(stone.getColor().displayName()) + ':' + provider.getMoveLabel(stone.getPoint()))));
    }

    @Override
    public void execute() {
        super.execute();
        this.sgfCommand_.execute();
        EditableNodeList nodeList = this.getEditableNodeList();
        this.lastChain_.clear();
        NodeEntity last = nodeList.removeLast();
        while (last != this.baseEntity_) {
            this.lastChain_.addFirst(last);
            last = nodeList.removeLast();
        }
        nodeList.addLast(last);
        NodeEntity topEntity = null;
        for (Node node : this.newTree_.getSequence()) {
            NodeEntity entity = nodeList.addLast(node, this.newTree_);
            NodeEntity nodeEntity = topEntity = topEntity == null ? entity : topEntity;
        }
        int selectionId = this.baseEntity_.getNodeTree().getGameTree().getChildrenSize() - 1;
        if (last.getNodeTree().isChildrenStyle()) {
            last.setSelectedVariationIndex(selectionId);
        } else if (topEntity != null) {
            topEntity.setSelectedVariationIndex(selectionId);
        }
    }

    @Override
    public void undo() {
        super.undo();
        this.sgfCommand_.undo();
        NodeEntity last = this.getEditableNodeList().removeLast();
        while (!last.equals(this.baseEntity_)) {
            last = this.getEditableNodeList().removeLast();
        }
        this.getEditableNodeList().addLast(last);
        this.getEditableNodeList().addLast(this.lastChain_.toArray(new NodeEntity[this.lastChain_.size()]));
    }

    @Override
    public EnumSet<ModelInfluence> getInfluence() {
        return this.influences_;
    }
}

