/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.model.cmd;

import java.io.File;
import java.util.EnumSet;
import org.apache.commons.io.FilenameUtils;
import org.unitarou.cmd.Command;
import org.unitarou.cmd.NullCommand;
import org.unitarou.io.Ios;
import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.Value;
import org.unitarou.sgf.type.GameType;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.model.EditableNodeList;
import org.unitarou.yukinoshita.model.cmd.Command4NodeList;
import org.unitarou.yukinoshita.model.cmd.ModelInfluence;
import org.unitarou.yukinoshita.model.cmd.UpdateProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeFileName
extends Command4NodeList {
    private static final MessageResource LB_NAME = new MessageResource(ChangeFileName.class, "lbName");
    private final Collection collection_;
    private final File lastFile_;
    private final File newFile_;
    private Command command_;
    static /* synthetic */ Class class$0;

    public ChangeFileName(Collection collection, File newFile) {
        ArgumentChecker.throwIfNull((Object)collection, (Object)newFile);
        this.collection_ = collection;
        this.lastFile_ = collection.getFile();
        this.newFile_ = newFile;
        this.command_ = null;
        this.setDisplayName(LB_NAME.get());
    }

    @Override
    protected boolean setup() {
        if (this.command_ != null) {
            return true;
        }
        if (this.getEditableNodeList() == null) {
            return false;
        }
        this.command_ = this.composeCommand();
        return true;
    }

    private Command composeCommand() {
        String now;
        if (!this.collection_.get(0).getGameType().equals(GameType.DRILL)) {
            return NullCommand.INSTANCE;
        }
        String old = FilenameUtils.getFullPath(this.collection_.getFile().getAbsolutePath());
        if (old.equals(now = FilenameUtils.getFullPath(this.newFile_.getAbsolutePath()))) {
            return NullCommand.INSTANCE;
        }
        EditableNodeList nodeList = this.getEditableNodeList();
        if (nodeList.size() < 2) {
            return NullCommand.INSTANCE;
        }
        int i = 0;
        while (i < nodeList.size()) {
            Property property = nodeList.get(i).getNode().getProperty(SgfId.INPUT_FILES);
            if (property != null) {
                this.setExecutedNodeIndex(nodeList.getPositionIndex());
                this.setUndoneNodeIndex(nodeList.getPositionIndex());
                nodeList.setPositionIndex(i);
                Property newProperty = new Property();
                newProperty.setEntireId(SgfId.INPUT_FILES.id());
                Value[] valueArray = property.value().getValues();
                int n = 0;
                int n2 = valueArray.length;
                while (n < n2) {
                    Value value = valueArray[n];
                    String filename = FilenameUtils.concat(old, value.getString());
                    Value newValue = new Value(value);
                    newValue.setString(Ios.calcRelativePath(now, filename));
                    newProperty.value().addValue(newValue);
                    ++n;
                }
                return new UpdateCommand(property, newProperty, nodeList);
            }
            ++i;
        }
        return NullCommand.INSTANCE;
    }

    @Override
    public void execute() {
        super.execute();
        this.command_.execute();
        this.collection_.setFile(this.newFile_);
    }

    @Override
    public void undo() {
        super.undo();
        this.collection_.setFile(this.lastFile_);
        this.command_.undo();
    }

    @Override
    public EnumSet<ModelInfluence> getInfluence() {
        return EnumSet.of(ModelInfluence.COLLECTION);
    }

    private class UpdateCommand
    implements Command {
        private final UpdateProperty removeLast_;
        private final UpdateProperty addRepleaced_;

        UpdateCommand(Property old, Property now, EditableNodeList nodeList) {
            this.removeLast_ = new UpdateProperty(new Property[]{old}, null, null);
            this.addRepleaced_ = new UpdateProperty(new Property[0], now, null);
            this.removeLast_.setEditableNodeList(nodeList);
            this.addRepleaced_.setEditableNodeList(nodeList);
        }

        public void execute() {
            this.removeLast_.execute();
            this.addRepleaced_.execute();
        }

        public void undo() {
            this.addRepleaced_.undo();
            this.removeLast_.undo();
        }
    }
}

