/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.model.cmd;

import java.util.EnumSet;
import org.unitarou.cmd.Command;
import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.Sequence;
import org.unitarou.sgf.cmd.RemoveGameTree;
import org.unitarou.yukinoshita.model.EditableNodeList;
import org.unitarou.yukinoshita.model.NodeEntity;
import org.unitarou.yukinoshita.model.NodeTree;
import org.unitarou.yukinoshita.model.cmd.Command4NodeList;
import org.unitarou.yukinoshita.model.cmd.ModelInfluence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoveVariation
extends Command4NodeList {
    private static final MessageResource LB_NAME = new MessageResource(RemoveVariation.class, "lbName");
    private final int targetIndex_;
    private Command sgfCommand_;
    private GameTree target_;
    private NodeEntity undoStart_;
    static /* synthetic */ Class class$0;

    public RemoveVariation(int targetIndex) {
        this.targetIndex_ = targetIndex;
        this.sgfCommand_ = null;
        this.target_ = null;
        this.undoStart_ = null;
        this.setDisplayName(LB_NAME.get());
    }

    @Override
    protected boolean setup() {
        if (this.sgfCommand_ != null) {
            return true;
        }
        EditableNodeList nodeList_ = this.getEditableNodeList();
        if (nodeList_ == null) {
            return false;
        }
        if (this.targetIndex_ < 0 || nodeList_.size() <= this.targetIndex_) {
            throw new IndexOutOfBoundsException("index = " + this.targetIndex_);
        }
        NodeEntity target = this.getEditableNodeList().get(this.targetIndex_);
        NodeTree nodeTree = target.getNodeTree();
        this.sgfCommand_ = new RemoveGameTree(nodeTree.getParentGameTree(), nodeTree.getGameTree());
        this.target_ = nodeTree.getGameTree();
        this.undoStart_ = null;
        this.setExecutedNodeIndex(nodeList_.getPositionIndex());
        this.setUndoneNodeIndex(nodeList_.getPositionIndex());
        return true;
    }

    @Override
    public void execute() {
        NodeEntity start;
        super.execute();
        this.sgfCommand_.execute();
        NodeEntity last = this.getEditableNodeList().removeLast();
        while (last.getNodeTree().getGameTree().equals(this.target_)) {
            last = this.getEditableNodeList().removeLast();
        }
        this.undoStart_ = start = this.getEditableNodeList().removeLast();
        this.getEditableNodeList().addLast(start);
        this.updateMoveList(start);
    }

    @Override
    public void undo() {
        super.undo();
        this.sgfCommand_.undo();
        NodeEntity last = this.getEditableNodeList().removeLast();
        while (last.equals(this.undoStart_)) {
            last = this.getEditableNodeList().removeLast();
        }
        this.updateMoveList(this.undoStart_);
    }

    private void updateMoveList(NodeEntity start) {
        GameTree startGameTree = start.getNodeTree().getGameTree();
        Sequence.Iterator ip = startGameTree.getSequence().iterator();
        while (ip.hasNext()) {
            if (!ip.next().equals(start.getNode())) continue;
            while (ip.hasNext()) {
                this.getEditableNodeList().addLast(ip.next(), startGameTree);
            }
        }
        GameTree[] child = startGameTree.getChildren();
        if (child.length != 0) {
            this.getEditableNodeList().addLast(child[0]);
        }
    }

    @Override
    public EnumSet<ModelInfluence> getInfluence() {
        return EnumSet.of(ModelInfluence.NODE_CURRENT);
    }
}

