/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitarou.cmd.RedoUndoController;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.io.CollectionRepository;
import org.unitarou.sgf.type.GameType;
import org.unitarou.util.Adaptable;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.util.Provider;
import org.unitarou.util.StopWatch;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.context.ContextListener;
import org.unitarou.yukinoshita.context.CurrentContext;
import org.unitarou.yukinoshita.events.ActionListener;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.events.EventBrokerImpl;
import org.unitarou.yukinoshita.model.CollectionEditor;
import org.unitarou.yukinoshita.model.GameMediator;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.model.cmd.Command4NodeList;
import org.unitarou.yukinoshita.model.cmd.ModelInfluence;
import org.unitarou.yukinoshita.view.CollectionViewer;
import org.unitarou.yukinoshita.view.ContextViewer;
import org.unitarou.yukinoshita.view.GameViewer;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.ModelFrame;
import org.unitarou.yukinoshita.view.NodeViewer;
import org.unitarou.yukinoshita.view.ViewerUtils;
import org.unitarou.yukinoshita.view.cmd.ChangeEditModeCommand;
import org.unitarou.yukinoshita.view.cmd.Command4View;
import org.unitarou.yukinoshita.view.cmd.WrapperCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GameFrameController
implements Adaptable {
    private static final Log log_s_ = LogFactory.getLog(GameFrameController.class);
    private final CollectionEditor collectionEditor_;
    private final ListenerAdapter listenerAdapter_;
    private final ModelFrame modelFrame_;
    private final EventBrokerImpl eventBrokerImpl_;
    private boolean isEditMode_;
    private final Map<Class, ModelFrame> modelFrameMap_;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    public GameFrameController(Collection collection, ModelFrame modelFrame) {
        this(collection, modelFrame, false);
    }

    public GameFrameController(Collection collection, ModelFrame modelFrame, boolean setChangedFlag) {
        ArgumentChecker.throwIfNull((Object)collection, (Object)modelFrame);
        if (collection.size() == 0) {
            throw new IllegalArgumentException("collection must have one or more games.");
        }
        this.listenerAdapter_ = new ListenerAdapter();
        this.collectionEditor_ = new CollectionEditor(collection, setChangedFlag);
        this.eventBrokerImpl_ = new EventBrokerImpl();
        this.isEditMode_ = false;
        this.eventBrokerImpl_.addController(this);
        this.eventBrokerImpl_.addView(this);
        this.modelFrameMap_ = new HashMap<Class, ModelFrame>();
        this.modelFrame_ = modelFrame;
        this.modelFrame_.setEventBroker(this.eventBrokerImpl_);
        if (collection.get(0).getGameType().equals(GameType.DRILL)) {
            ViewerUtils.setupDriiRootDirectory(collection);
            CollectionRepository.instance().loadProblem(collection);
            if (1 < collection.size()) {
                this.collectionEditor_.setActiveGame(1);
            }
        }
        this.fireCollectionViewerUpdate();
        this.fireGameViewerUpdate();
        this.fireNodeViewerUpdate();
        Yukinoshita.context().addListener(this.listenerAdapter_);
    }

    public void registerModelFrame(ModelFrame modelFrame) {
        ArgumentChecker.throwIfNull((Object)modelFrame);
        modelFrame.setEventBroker(this.eventBrokerImpl_);
        this.modelFrameMap_.put(modelFrame.getClass(), modelFrame);
        this.fireCollectionViewerUpdate();
        this.fireGameViewerUpdate();
        this.eventBrokerImpl_.executeCommand(new ChangeEditModeCommand(this.isEditMode_));
    }

    @Override
    public Object getAdapter(Class<?> adapter) {
        if (adapter == null) {
            return null;
        }
        if (adapter.isAssignableFrom(this.listenerAdapter_.getClass())) {
            return this.listenerAdapter_;
        }
        return null;
    }

    public void dispose() {
        this.collectionEditor_.dispose();
        this.modelFrame_.dispose();
        this.eventBrokerImpl_.removeController(this);
        this.eventBrokerImpl_.dispose();
    }

    public CollectionEditor getCollectionEditor() {
        return this.collectionEditor_;
    }

    public Collection getCollection() {
        return this.collectionEditor_.getCollection();
    }

    public boolean isChanged() {
        boolean[] flags = this.collectionEditor_.getChangedFlags();
        int i = 0;
        while (i < flags.length) {
            if (flags[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void clearChangedFlag() {
        this.collectionEditor_.clearChangedFlags();
        this.fireNodeViewerUpdate();
    }

    public boolean[] getChangedFlags() {
        return this.collectionEditor_.getChangedFlags();
    }

    public boolean isEditMode() {
        return this.isEditMode_;
    }

    public RedoUndoController getActiveRedoUndoController() {
        return this.collectionEditor_.getActiveGame().getRedoUndoController();
    }

    public void updateByRedoUndo(EnumSet<ModelInfluence> name) {
        block7: for (ModelInfluence influence : name) {
            switch (influence) {
                case COLLECTION: {
                    this.fireCollectionViewerUpdate();
                    break;
                }
                case ROOT_GAME_TREE: {
                    this.fireGameViewerUpdate();
                    break;
                }
                case NODE_PEVIOUS: {
                    this.fireGameViewerUpdate();
                    break;
                }
                case NODE_DOWNWARD: {
                    this.fireGameViewerUpdate();
                    break;
                }
                case NODE_CURRENT: {
                    this.fireNodeViewerUpdate();
                    break;
                }
                default: {
                    assert (false) : "Unknown type:" + (Object)((Object)influence);
                    continue block7;
                }
            }
        }
        this.fireNodeViewerUpdate();
    }

    public EventBroker getEventBroker() {
        return this.eventBrokerImpl_;
    }

    private void fireCollectionViewerUpdate() {
        GameType gameType = this.collectionEditor_.getActiveGame().getGameType();
        this.eventBrokerImpl_.connect(gameType, this.isEditMode_);
        for (CollectionViewer viewer : this.eventBrokerImpl_.getListeners(CollectionViewer.class)) {
            viewer.update(this.collectionEditor_);
        }
    }

    private void fireGameViewerUpdate() {
        ViewerUtils.setupDriiRootDirectory(this.collectionEditor_.getCollection());
        GameMediator gameMediator = this.collectionEditor_.getActiveGame();
        for (GameViewer gameViewer : this.eventBrokerImpl_.getListeners(GameViewer.class)) {
            gameViewer.update(gameMediator);
        }
    }

    private void fireNodeViewerUpdate() {
        StopWatch stopWatch = new StopWatch();
        NodeView nodeView = this.collectionEditor_.getActiveGame().getCurrentNodeView();
        for (NodeViewer nodeViewer : this.eventBrokerImpl_.getListeners(NodeViewer.class)) {
            nodeViewer.update(nodeView);
            if (!log_s_.isTraceEnabled()) continue;
            log_s_.trace(String.valueOf(stopWatch.lapSecond()) + " secs for " + nodeViewer);
        }
        if (log_s_.isTraceEnabled()) {
            log_s_.trace(String.valueOf(stopWatch.stopSecond()) + " secs for fireNodeViewerUpdate");
        }
    }

    private void fireContextAttributeChanged(Set<String> keySet) {
        for (ContextViewer contextViewer : this.eventBrokerImpl_.getListeners(ContextViewer.class)) {
            contextViewer.attributeChanged(keySet);
        }
    }

    public <T extends Provider> void changeProvider(Class<T> providerInterface, Provider provider) {
        ArgumentChecker.throwIfNull(providerInterface, (Object)provider);
        GameMediator gameMediator = this.collectionEditor_.getActiveGame();
        CurrentContext context = gameMediator.getContext();
        context.setProvider(providerInterface, provider);
        HashSet<String> set = new HashSet<String>();
        set.add(providerInterface.getName());
        Set<String> keySet = Collections.unmodifiableSet(set);
        this.fireContextAttributeChanged(keySet);
    }

    public <T extends Provider> T getProvider(Class<T> providerInterface) {
        ArgumentChecker.throwIfNull(providerInterface);
        GameMediator gameMediator = this.collectionEditor_.getActiveGame();
        CurrentContext context = gameMediator.getContext();
        return context.getProvider(providerInterface);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ListenerAdapter
    implements ActionListener,
    ContextListener {
        private HandlerPhase currentStatus_ = null;

        @Override
        public void executeCommand(Command4NodeList command) {
            ArgumentChecker.throwIfNull((Object)command);
            WrapperCommand wrapperCommand = new WrapperCommand(command);
            wrapperCommand.getParameter().set(GameFrameController.this.collectionEditor_, GameFrameController.this.eventBrokerImpl_, GameFrameController.this.isEditMode_);
            wrapperCommand.execute();
        }

        @Override
        public void executeCommand(Command4View command) {
            ArgumentChecker.throwIfNull((Object)command);
            Command4View.Parameter parameter = command.getParameter();
            parameter.setCollectionEditor(GameFrameController.this.collectionEditor_);
            parameter.setEventBroker(GameFrameController.this.eventBrokerImpl_);
            if (parameter.isEditMode() == null) {
                parameter.setEditMode(GameFrameController.this.isEditMode_);
            } else {
                GameFrameController.this.isEditMode_ = parameter.isEditMode();
            }
            if (parameter.getCurrentStatus() == null && this.currentStatus_ != null) {
                parameter.setCurrentStatus(this.currentStatus_);
            }
            command.execute();
            this.currentStatus_ = parameter.getCurrentStatus();
        }

        @Override
        public void attributeChanged(Set<String> keySet) {
            ArgumentChecker.throwIfNull(keySet);
            GameFrameController.this.fireContextAttributeChanged(keySet);
        }
    }
}

