/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.cmd;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitarou.sgf.type.GameType;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.util.StopWatch;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.model.CollectionEditor;
import org.unitarou.yukinoshita.model.GameMediator;
import org.unitarou.yukinoshita.model.NodeList;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.model.ProblemStatus;
import org.unitarou.yukinoshita.view.CollectionViewer;
import org.unitarou.yukinoshita.view.ControllerStatusViewer;
import org.unitarou.yukinoshita.view.GameViewer;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.NodeListViewer;
import org.unitarou.yukinoshita.view.NodeViewer;
import org.unitarou.yukinoshita.view.ProblemStatusViewer;
import org.unitarou.yukinoshita.view.ViewerUtils;
import org.unitarou.yukinoshita.view.cmd.Command4View;

public abstract class AbstractCommand4View
implements Command4View {
    private static final Log log_s_ = LogFactory.getLog(AbstractCommand4View.class);
    private final ParameterImpl parameter_ = new ParameterImpl();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;

    public final Command4View.Parameter getParameter() {
        return this.parameter_;
    }

    protected final CollectionEditor getCollectionEditor() {
        return this.parameter_.collectionEditor_;
    }

    protected final EventBroker getEventBroker() {
        return this.parameter_.eventBroker_;
    }

    protected final Boolean isEditMode() {
        return this.parameter_.isEditMode_;
    }

    protected final void fireCollectionViewerUpdate() {
        this.throwIfNotSetup();
        GameType gameType = this.parameter_.collectionEditor_.getActiveGame().getGameType();
        this.parameter_.eventBroker_.connect(gameType, this.parameter_.isEditMode_);
        for (CollectionViewer viewer : this.parameter_.eventBroker_.getListeners(CollectionViewer.class)) {
            viewer.update(this.parameter_.collectionEditor_);
        }
    }

    protected final void fireGameViewerUpdate() {
        this.throwIfNotSetup();
        ViewerUtils.setupDriiRootDirectory(this.parameter_.collectionEditor_.getCollection());
        GameMediator gameMediator = this.parameter_.collectionEditor_.getActiveGame();
        for (GameViewer gameViewer : this.parameter_.eventBroker_.getListeners(GameViewer.class)) {
            gameViewer.update(gameMediator);
        }
    }

    protected final void fireNodeListUpdate() {
        this.throwIfNotSetup();
        GameMediator gameMediator = this.parameter_.collectionEditor_.getActiveGame();
        NodeList nodeList = gameMediator.getNodeList();
        int start = gameMediator.getCurrentNodeIndex();
        int end = nodeList.size();
        int index = 0;
        NodeView[] nodeViews = new NodeView[end - start];
        int i = start;
        while (i < end) {
            nodeViews[index] = nodeList.getNodeView(i);
            ++index;
            ++i;
        }
        for (NodeListViewer nodeListViewer : this.parameter_.eventBroker_.getListeners(NodeListViewer.class)) {
            nodeListViewer.update(nodeViews);
        }
    }

    protected final void fireNodeViewerUpdate() {
        this.fireNodeViewerUpdate(0);
    }

    protected final void fireNodeViewerUpdate(int delta) {
        this.throwIfNotSetup();
        StopWatch stopWatch = new StopWatch();
        GameMediator gameMediator = this.parameter_.collectionEditor_.getActiveGame();
        int index = gameMediator.getCurrentNodeIndex() + delta;
        if (index < 0 || gameMediator.getNodeList().size() <= index) {
            index = gameMediator.getCurrentNodeIndex();
            log_s_.warn("Bad index, index=" + index + ", delta=" + delta);
        }
        NodeView nodeView = gameMediator.getNodeList().getNodeView(index);
        for (NodeViewer nodeViewer : this.parameter_.eventBroker_.getListeners(NodeViewer.class)) {
            nodeViewer.update(nodeView);
            if (!log_s_.isTraceEnabled()) continue;
            log_s_.trace(String.valueOf(stopWatch.lapSecond()) + " secs for " + nodeViewer);
        }
        if (log_s_.isTraceEnabled()) {
            log_s_.trace(String.valueOf(stopWatch.stopSecond()) + " secs for fireNodeViewerUpdate");
        }
    }

    protected final void fireHandlerPhaseChange(HandlerPhase phase) {
        ArgumentChecker.throwIfNull((Object)phase);
        if (phase.equals(HandlerPhase.SOLVE)) {
            this.parameter_.collectionEditor_.getActiveGame().startSolvingProblem();
            this.fireNodeViewerUpdate();
        } else if (phase.equals(HandlerPhase.NEXT_PROBLEM)) {
            this.parameter_.collectionEditor_.getActiveGame().finishSolvingProblem();
            int newIndex = this.parameter_.collectionEditor_.getActiveGameIndex() + 1;
            if (newIndex < this.parameter_.collectionEditor_.size()) {
                this.parameter_.collectionEditor_.setActiveGame(newIndex);
                this.fireGameViewerUpdate();
                this.fireProblemStatusUpdate(ProblemStatus.SOLVE);
            }
            this.parameter_.collectionEditor_.getActiveGame().startSolvingProblem();
            this.fireNodeViewerUpdate();
        }
        for (ControllerStatusViewer viewer : this.parameter_.eventBroker_.getListeners(ControllerStatusViewer.class)) {
            viewer.changeHandlerPhase(phase);
        }
    }

    protected final void fireProblemStatusUpdate(ProblemStatus problemStatus) {
        ArgumentChecker.throwIfNull((Object)problemStatus);
        for (ProblemStatusViewer viewer : this.parameter_.eventBroker_.getListeners(ProblemStatusViewer.class)) {
            viewer.update(problemStatus);
        }
    }

    protected final void throwIfNotSetup() {
        if (this.parameter_.collectionEditor_ == null || this.parameter_.eventBroker_ == null || this.parameter_.isEditMode_ == null) {
            throw new IllegalStateException("Bad state, CollectionEditor and EventBroker must be set before method invocationcollectionEditor_=" + this.parameter_.collectionEditor_ + ", eventBroker_=" + this.parameter_.eventBroker_ + ", isEditMode_=" + this.parameter_.isEditMode_);
        }
    }

    private class ParameterImpl
    implements Command4View.Parameter {
        private CollectionEditor collectionEditor_;
        private EventBroker eventBroker_;
        private Boolean isEditMode_;
        private HandlerPhase currentStatus_;

        ParameterImpl() {
        }

        public CollectionEditor getCollectionEditor() {
            return this.collectionEditor_;
        }

        public EventBroker getEventBroker() {
            return this.eventBroker_;
        }

        public Boolean isEditMode() {
            return this.isEditMode_;
        }

        public HandlerPhase getCurrentStatus() {
            return this.currentStatus_;
        }

        public void set(CollectionEditor collectionEditor, EventBroker eventBroker, boolean isEditMode) {
            ArgumentChecker.throwIfNull((Object)collectionEditor, (Object)eventBroker);
            this.collectionEditor_ = collectionEditor;
            this.eventBroker_ = eventBroker;
            this.isEditMode_ = new Boolean(isEditMode);
        }

        public void setCollectionEditor(CollectionEditor collectionEditor) {
            ArgumentChecker.throwIfNull((Object)collectionEditor);
            this.collectionEditor_ = collectionEditor;
        }

        public void setEventBroker(EventBroker eventBroker) {
            ArgumentChecker.throwIfNull((Object)eventBroker);
            this.eventBroker_ = eventBroker;
        }

        public void setEditMode(boolean isEditMode) {
            this.isEditMode_ = new Boolean(isEditMode);
        }

        public void setCurrentStatus(HandlerPhase handlerPhase) {
            ArgumentChecker.throwIfNull((Object)handlerPhase);
            this.currentStatus_ = handlerPhase;
        }
    }
}

