/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.cmd;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.io.CollectionRepository;
import org.unitarou.sgf.type.GameType;
import org.unitarou.util.StopWatch;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.model.CollectionEditor;
import org.unitarou.yukinoshita.model.GameMediator;
import org.unitarou.yukinoshita.view.ControllerStatusViewer;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.ViewerUtils;
import org.unitarou.yukinoshita.view.cmd.AbstractCommand4View;

public class ChangeEditModeCommand
extends AbstractCommand4View {
    private static Log log_s_ = LogFactory.getLog(ChangeEditModeCommand.class);
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public ChangeEditModeCommand(boolean isEditMode) {
        this.getParameter().setEditMode(isEditMode);
    }

    public void execute() {
        this.throwIfNotSetup();
        StopWatch stopWatch = new StopWatch();
        CollectionEditor collectionEditor = this.getCollectionEditor();
        EventBroker eventBroker = this.getEventBroker();
        boolean isEditMode = this.isEditMode();
        if (GameType.DRILL.equals(collectionEditor.getCollection().get(0).getGameType())) {
            this.editModeChangedInDrill();
        } else {
            GameMediator gameMediator = collectionEditor.getActiveGame();
            eventBroker.connect(gameMediator.getGameType(), isEditMode);
            if (gameMediator.getGameType().equals(GameType.PROBLEM)) {
                if (isEditMode) {
                    gameMediator.finishSolvingProblem();
                    this.fireNodeViewerUpdate();
                } else {
                    gameMediator.startSolvingProblem();
                    this.fireHandlerPhaseChange(HandlerPhase.SOLVE);
                }
            }
        }
        if (log_s_.isTraceEnabled()) {
            log_s_.trace(String.valueOf(stopWatch.stopSecond()) + " secs for update");
        }
        for (ControllerStatusViewer viewer : eventBroker.getListeners(ControllerStatusViewer.class)) {
            viewer.setEditMode(isEditMode);
        }
        if (log_s_.isTraceEnabled()) {
            log_s_.trace(String.valueOf(stopWatch.stopSecond()) + " secs for ControllerStatusViewer.setEditMode");
        }
    }

    private void editModeChangedInDrill() {
        CollectionEditor collectionEditor = this.getCollectionEditor();
        EventBroker eventBroker_ = this.getEventBroker();
        boolean isEditMode = this.isEditMode();
        if (isEditMode) {
            collectionEditor.getActiveGame().finishSolvingProblem();
            collectionEditor.setActiveGame(0);
            while (1 < collectionEditor.size()) {
                collectionEditor.remove(1);
            }
            eventBroker_.connect(collectionEditor.getActiveGame().getGameType(), isEditMode);
            this.fireGameViewerUpdate();
            this.fireNodeViewerUpdate();
        } else {
            Collection collection = collectionEditor.getCollection();
            ViewerUtils.setupDriiRootDirectory(collection);
            CollectionRepository.instance().loadProblem(collection);
            collectionEditor.setActiveGame(1);
            eventBroker_.connect(collectionEditor.getActiveGame().getGameType(), isEditMode);
            this.fireGameViewerUpdate();
            collectionEditor.getActiveGame().startSolvingProblem();
            this.fireHandlerPhaseChange(HandlerPhase.SOLVE);
        }
    }
}

