/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.cmd;

import java.util.Random;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.SgfColor;
import org.unitarou.sgf.type.SgfDouble;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.util.SgfPointType;
import org.unitarou.sgf.util.Stone;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.model.GameMediator;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.model.ProblemStatus;
import org.unitarou.yukinoshita.model.cmd.AddVariation;
import org.unitarou.yukinoshita.model.cmd.SelectVariation;
import org.unitarou.yukinoshita.model.cmd.UpdateProperty;
import org.unitarou.yukinoshita.view.cmd.AbstractCommand4View;

public class MoveInProblemCommand
extends AbstractCommand4View {
    private final SgfPoint point_;

    public MoveInProblemCommand(SgfPoint point) {
        ArgumentChecker.throwIfNull((Object)point);
        this.point_ = point;
    }

    public void execute() {
        this.throwIfNotSetup();
        GameMediator gameMediator = this.getCollectionEditor().getActiveGame();
        if (this.selectPlayerMove(gameMediator, this.point_)) {
            this.fireNodeViewerUpdate();
            this.fireProblemStatusUpdate(ProblemStatus.WRONG);
            return;
        }
        SgfColor player = gameMediator.getCurrentNodeView().getMove().getColor();
        try {
            this.fireNodeViewerUpdate();
            Thread.sleep(200L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.selectOppositeMove(gameMediator)) {
            this.fireNodeViewerUpdate();
        }
        if (!gameMediator.getCurrentNodeView().isLast()) {
            return;
        }
        if (this.isInMainPath(gameMediator)) {
            this.fireProblemStatusUpdate(ProblemStatus.CORRECT);
            return;
        }
        NodeView nodeView = gameMediator.getCurrentNodeView();
        if (this.isGoodForPlayer(nodeView, player)) {
            this.fireProblemStatusUpdate(ProblemStatus.CORRECT);
        } else {
            this.fireProblemStatusUpdate(ProblemStatus.WRONG);
        }
    }

    private boolean selectPlayerMove(GameMediator gameMediator, SgfPoint point) {
        NodeView nodeView = gameMediator.getCurrentNodeView();
        if (nodeView.isChildrenStyle()) {
            boolean selected = this.selectPlayerMoveByVariation(gameMediator, point);
            NodeView nextNode = gameMediator.setNodeIndexDelta(1);
            if (selected) {
                return false;
            }
            if (point.equals(nextNode.getMove().getPoint())) {
                return false;
            }
            gameMediator.setNodeIndexDelta(-1);
            gameMediator.executeCommand(new AddVariation(nextNode.getMove().getColor(), point));
            gameMediator.setNodeIndexDelta(1);
            return true;
        }
        NodeView nextNode = gameMediator.setNodeIndexDelta(1);
        if (this.selectPlayerMoveByVariation(gameMediator, point)) {
            return false;
        }
        if (point.equals(nextNode.getMove().getPoint())) {
            return false;
        }
        gameMediator.setNodeIndexDelta(-1);
        gameMediator.executeCommand(new AddVariation(nextNode.getMove().getColor(), point));
        return false;
    }

    private boolean selectPlayerMoveByVariation(GameMediator gameMediator, SgfPoint point) {
        NodeView nodeView = gameMediator.getCurrentNodeView();
        NodeView[] variations = nodeView.getVariations();
        if (variations.length == 0) {
            return false;
        }
        int passNodeIndex = -1;
        Stone passMove = null;
        int i = 0;
        while (i < variations.length) {
            passMove = variations[i].getMove();
            SgfPoint varPoint = passMove.getPoint();
            if (passNodeIndex == -1 && varPoint != null && varPoint.condition().equals((Object)SgfPointType.PASS)) {
                passNodeIndex = i;
            } else if (point.equals(varPoint)) {
                gameMediator.executeCommand(new SelectVariation(i));
                return true;
            }
            ++i;
        }
        if (passNodeIndex != -1) {
            gameMediator.executeCommand(new SelectVariation(passNodeIndex));
            SgfId sgfId = passMove.getColor().moveType();
            gameMediator.executeCommand(new UpdateProperty(new Property[0], new Property(sgfId, point.getString()), null));
            return true;
        }
        return false;
    }

    private boolean selectOppositeMove(GameMediator gameMediator) {
        NodeView playerView = gameMediator.getCurrentNodeView();
        if (playerView.isLast()) {
            return false;
        }
        if (playerView.isChildrenStyle()) {
            NodeView[] variations = playerView.getVariations();
            if (variations.length != 0) {
                Random random = new Random();
                gameMediator.executeCommand(new SelectVariation(random.nextInt(variations.length)));
            }
            gameMediator.setNodeIndexDelta(1);
            return true;
        }
        gameMediator.setNodeIndexDelta(1);
        NodeView[] variations = gameMediator.getCurrentNodeView().getVariations();
        if (variations.length != 0) {
            Random random = new Random();
            gameMediator.executeCommand(new SelectVariation(random.nextInt(variations.length)));
        }
        return true;
    }

    private boolean isInMainPath(GameMediator gameMediator) {
        int index = gameMediator.getCurrentNodeIndex();
        while (index >= 0) {
            NodeView n = gameMediator.getNodeList().getNodeView(index);
            if (n.getSelectedVariationIndex() > 0) {
                return false;
            }
            --index;
        }
        return true;
    }

    private boolean isGoodForPlayer(NodeView nodeView, SgfColor player) {
        Property property = null;
        if (SgfColor.BLACK.equals(player)) {
            property = nodeView.getProperty(SgfId.GOOD_FOR_BLACK);
        } else if (SgfColor.WHITE.equals(player)) {
            property = nodeView.getProperty(SgfId.GOOD_FOR_WHITE);
        }
        if (property != null) {
            return SgfDouble.EMPHASIZED.equals(SgfDouble.parseQuietly(property.value().getString()));
        }
        return false;
    }
}

