/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface;

import java.io.File;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.window.Window;
import org.eclipse.jface.window.WindowManager;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.unitarou.ml.BasicMessages;
import org.unitarou.ml.MessageResource;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.Application;
import org.unitarou.yukinoshita.context.Context;
import org.unitarou.yukinoshita.view.WindowController;
import org.unitarou.yukinoshita.view.jface.JFaceContext;
import org.unitarou.yukinoshita.view.jface.JFaceWindow;
import org.unitarou.yukinoshita.view.jface.board.sp.StonePainter;

public class JFaceApplication
implements Application {
    private static final Log log_s_ = LogFactory.getLog(JFaceApplication.class);
    private final WindowManager windowManager_;
    private final JFaceContext context_;
    private final Display display_ = new Display();
    private final Shell shell_;
    private static final MessageResource MSG_INNER_ERROR = new MessageResource(JFaceApplication.class, "msgInnerError");
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public JFaceApplication() {
        this.windowManager_ = new WindowManager();
        this.context_ = new JFaceContext();
        this.context_.registerInterface(StonePainter.class);
        Window.setExceptionHandler(new ExceptionHandler());
        this.shell_ = new Shell(this.display_);
    }

    public void dispose() {
        this.display_.dispose();
    }

    public void start() {
        this.context_.registerProvider(StonePainter.CONTEXT.defaultProvider().getClass());
        try {
            this.createWindow();
            while (!this.shell_.isDisposed()) {
                if (!this.display_.readAndDispatch()) {
                    this.display_.sleep();
                }
                if (this.windowManager_.getWindowCount() != 0) continue;
                this.shell_.dispose();
            }
            this.context_.saveContext();
        }
        finally {
            Display.getCurrent().dispose();
        }
    }

    public void createWindow() {
        JFaceWindow window = new JFaceWindow(null);
        this.windowManager_.add(window);
        window.setBlockOnOpen(false);
        window.open();
    }

    public void closeAllWindows() {
        this.windowManager_.close();
    }

    public Context getContext() {
        return this.context_;
    }

    public void openMessageDialog(Application.MessageLevel level, String title, String message) {
        ArgumentChecker.throwIfNull((Object)level, (Object)title, (Object)message);
        Display display = Display.getCurrent();
        Shell shell = display != null ? display.getActiveShell() : new Shell();
        switch (level) {
            case ERROR: {
                MessageDialog.openError(shell, title, message);
                break;
            }
            case WARNING: {
                MessageDialog.openWarning(shell, title, message);
                break;
            }
            case INFORMATION: {
                MessageDialog.openInformation(shell, title, message);
                break;
            }
            default: {
                assert (false) : "Unknown type:" + (Object)((Object)level);
                break;
            }
        }
    }

    public File openDirectoryDialog(String title, String message, File currentDirectory) {
        ArgumentChecker.throwIfNull((Object)title, (Object)message, (Object)currentDirectory);
        DirectoryDialog directoryDialog = new DirectoryDialog(Display.getCurrent().getActiveShell());
        directoryDialog.setText(title);
        directoryDialog.setMessage(message);
        String path = currentDirectory.isDirectory() ? currentDirectory.getAbsolutePath() : currentDirectory.getParentFile().getAbsolutePath();
        directoryDialog.setFilterPath(path);
        path = directoryDialog.open();
        return path == null ? null : new File(path);
    }

    public WindowController[] getAllController() {
        Window[] windows = this.windowManager_.getWindows();
        ArrayList<WindowController> controllers = new ArrayList<WindowController>(windows.length - 1);
        Window[] windowArray = windows;
        int n = 0;
        int n2 = windowArray.length;
        while (n < n2) {
            Window window = windowArray[n];
            if (window instanceof WindowController) {
                controllers.add((WindowController)((Object)window));
            }
            ++n;
        }
        return controllers.toArray(new WindowController[controllers.size()]);
    }

    private class ExceptionHandler
    implements Window.IExceptionHandler {
        ExceptionHandler() {
        }

        public void handleException(Throwable t) {
            if (t instanceof ThreadDeath) {
                throw (ThreadDeath)t;
            }
            log_s_.error("Internal error occurred.", t);
            MessageDialog dig = new MessageDialog(Display.getCurrent().getActiveShell(), BasicMessages.NT_ERROR.get(), null, MSG_INNER_ERROR.get(), 1, new String[]{BasicMessages.CLB_CLOSE.get()}, 0);
            dig.open();
        }
    }
}

