/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.act;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.Action;
import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.SgfId;
import org.unitarou.util.Adaptable;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.events.WindowControllerListener;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.model.cmd.UpdateProperty;
import org.unitarou.yukinoshita.view.ControllerStatusViewer;
import org.unitarou.yukinoshita.view.GameFrameController;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.NodeViewer;
import org.unitarou.yukinoshita.view.WindowController;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClearPlPropertyAction
extends Action
implements Adaptable {
    private static final Log log_s_ = LogFactory.getLog(ClearPlPropertyAction.class);
    private static final MessageResource CLB_NAME = new MessageResource(ClearPlPropertyAction.class, "clbName");
    private final Adapter adapter_ = new Adapter();
    private WindowController controller_ = null;
    private Property target_ = null;
    static /* synthetic */ Class class$0;

    public ClearPlPropertyAction() {
        this.setText(CLB_NAME.get());
        this.setEnabled(false);
    }

    @Override
    public Object getAdapter(Class<?> adapter) {
        if (adapter == null) {
            return null;
        }
        if (adapter.isAssignableFrom(this.adapter_.getClass())) {
            return this.adapter_;
        }
        return null;
    }

    public ClearPlPropertyAction setController(WindowController controller) {
        ArgumentChecker.throwIfNull((Object)controller);
        if (this.controller_ != null) {
            this.controller_.removListener(this.adapter_);
        }
        this.controller_ = controller;
        this.controller_.addListener(this.adapter_);
        return this;
    }

    @Override
    public void run() {
        this.controller_.getActive().getEventBroker().executeCommand(new UpdateProperty(new Property[]{this.target_}, null, null));
    }

    private class Adapter
    implements NodeViewer,
    ControllerStatusViewer,
    WindowControllerListener {
        private Reference<GameFrameController> refGfc_ = new WeakReference<Object>(null);

        Adapter() {
        }

        public void update(NodeView nodeView) {
            GameFrameController gfc = this.refGfc_.get();
            if (gfc == null) {
                log_s_.warn("Lost GameFrameController (BUG)");
                return;
            }
            ArgumentChecker.throwIfNull((Object)nodeView);
            ClearPlPropertyAction.this.target_ = nodeView.getProperty(SgfId.PLAYER_TO_PLAY);
            ClearPlPropertyAction.this.setEnabled(gfc.isEditMode() && ClearPlPropertyAction.this.target_ != null);
        }

        public void changeActive(GameFrameController now) {
            GameFrameController last = this.refGfc_.get();
            if (last != null) {
                last.getEventBroker().removeView(ClearPlPropertyAction.this);
            }
            this.refGfc_ = new WeakReference<GameFrameController>(now);
            ClearPlPropertyAction.this.setEnabled(false);
            if (now != null) {
                now.getEventBroker().addView(ClearPlPropertyAction.this);
                this.update(now.getCollectionEditor().getActiveGame().getNodeList().getCurrentNodeView());
            }
        }

        public void changeHandlerPhase(HandlerPhase phase) {
        }

        public void setEditMode(boolean isEditMode) {
            ClearPlPropertyAction.this.setEnabled(isEditMode);
        }
    }
}

