/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.act;

import java.util.EnumSet;
import org.eclipse.swt.widgets.Display;
import org.unitarou.ml.BasicMessages;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.type.GameType;
import org.unitarou.yukinoshita.model.CollectionEditor;
import org.unitarou.yukinoshita.view.GameFrameController;
import org.unitarou.yukinoshita.view.WindowController;
import org.unitarou.yukinoshita.view.cmd.ChangeEditModeCommand;
import org.unitarou.yukinoshita.view.jface.act.AbstractRootGameTreeAction;
import org.unitarou.yukinoshita.view.jface.dlg.SelectTargetFileDialog;

public class CopyRootGameTreeAction
extends AbstractRootGameTreeAction {
    public CopyRootGameTreeAction(WindowController controller) {
        super(controller);
    }

    public void run() {
        EnumSet<SelectTargetFileDialog.Type> typeSet = this.getTypes();
        GameFrameController gfc = this.getGameFrameController();
        GameType gameType = gfc.getCollectionEditor().getActiveGame().getGameType();
        SelectTargetFileDialog dialog = new SelectTargetFileDialog(Display.getCurrent().getActiveShell(), typeSet);
        dialog.setShellTitle(String.valueOf(gameType.displayName()) + "\u306e\u30b3\u30d4\u30fc\u4f5c\u6210");
        dialog.setTitle(String.valueOf(gameType.displayName()) + "\u306e\u30b3\u30d4\u30fc\u5148\u3092\u6307\u5b9a\u3057\u3066\u4e0b\u3055\u3044\u3002");
        int ret = dialog.open();
        if (ret == 1) {
            return;
        }
        GameFrameController target = dialog.getTarget();
        int activeGameIndex = gfc.getCollectionEditor().getActiveGameIndex();
        RootGameTree newRgt = new RootGameTree(gfc.getCollection().get(activeGameIndex));
        if (target == null) {
            Collection collection = new Collection();
            collection.addLast(newRgt);
            this.controller_.register(collection, BasicMessages.LB_NEW_FILE.get(), false);
            this.controller_.getActive().getEventBroker().executeCommand(new ChangeEditModeCommand(true));
            return;
        }
        CollectionEditor editor = target.getCollectionEditor();
        editor.createGame(newRgt);
        this.notifyCollectionViewer(target);
        this.changeForLastGame(target);
    }

    protected boolean isRunnable(GameFrameController now) {
        if (now == null) {
            return false;
        }
        Collection collection = now.getCollection();
        if (collection.size() < 1) {
            return false;
        }
        return !GameType.DRILL.equals(collection.get(0).getGameType());
    }
}

