/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.act;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.widgets.MenuItem;
import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.None;
import org.unitarou.sgf.type.SgfColor;
import org.unitarou.sgf.type.SgfDouble;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.util.provider.crdlp.CoordinatesLabelProvider;
import org.unitarou.util.Adaptable;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.util.Provider;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.events.ModelEventNotifier;
import org.unitarou.yukinoshita.events.WindowControllerListener;
import org.unitarou.yukinoshita.model.GameMediator;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.view.ControllerStatusViewer;
import org.unitarou.yukinoshita.view.GameFrameController;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.NodeViewer;
import org.unitarou.yukinoshita.view.jface.JFaceContext;
import org.unitarou.yukinoshita.view.jface.JFaceWindow;
import org.unitarou.yukinoshita.view.jface.act.AboutAction;
import org.unitarou.yukinoshita.view.jface.act.ClearPlPropertyAction;
import org.unitarou.yukinoshita.view.jface.act.ClearTrashCanAction;
import org.unitarou.yukinoshita.view.jface.act.CloseAllTabAction;
import org.unitarou.yukinoshita.view.jface.act.CloseTabAction;
import org.unitarou.yukinoshita.view.jface.act.CopyRootGameTreeAction;
import org.unitarou.yukinoshita.view.jface.act.CreateWindowAction;
import org.unitarou.yukinoshita.view.jface.act.DefaultLayoutAction;
import org.unitarou.yukinoshita.view.jface.act.ExitAction;
import org.unitarou.yukinoshita.view.jface.act.LoadLayoutAction;
import org.unitarou.yukinoshita.view.jface.act.MoveRootGameTreeAction;
import org.unitarou.yukinoshita.view.jface.act.NewDrillFileAction;
import org.unitarou.yukinoshita.view.jface.act.NewGameFileAction;
import org.unitarou.yukinoshita.view.jface.act.NewProblemFileAction;
import org.unitarou.yukinoshita.view.jface.act.OpenFileAction;
import org.unitarou.yukinoshita.view.jface.act.OpenFromClipboard;
import org.unitarou.yukinoshita.view.jface.act.OpenPreferenceAction;
import org.unitarou.yukinoshita.view.jface.act.RedoAction;
import org.unitarou.yukinoshita.view.jface.act.RemoveNodeAction;
import org.unitarou.yukinoshita.view.jface.act.RemoveRootGameTreeAction;
import org.unitarou.yukinoshita.view.jface.act.SalvageFromTrashCanAction;
import org.unitarou.yukinoshita.view.jface.act.SaveAction;
import org.unitarou.yukinoshita.view.jface.act.SaveAsAction;
import org.unitarou.yukinoshita.view.jface.act.SaveLayoutAction;
import org.unitarou.yukinoshita.view.jface.act.SelectProviderAction;
import org.unitarou.yukinoshita.view.jface.act.SetMoveValueAction;
import org.unitarou.yukinoshita.view.jface.act.SetPositionValueAction;
import org.unitarou.yukinoshita.view.jface.act.SetVwAtRootAction;
import org.unitarou.yukinoshita.view.jface.act.ShowSgfText;
import org.unitarou.yukinoshita.view.jface.act.UndoAction;
import org.unitarou.yukinoshita.view.jface.act.UnsetVwAtRootAction;
import org.unitarou.yukinoshita.view.jface.board.sp.StonePainter;
import org.unitarou.yukinoshita.view.provider.blklp.BlockLabelProvider;
import org.unitarou.yukinoshita.view.provider.rgtlp.GreedyRgtLabelProvider;
import org.unitarou.yukinoshita.view.provider.rgtlp.RootGameTreeLabelProvider;
import org.unitarou.yukinoshita.view.provider.vlp.VariationLabelProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JFaceMenuManager
implements Adaptable {
    private static final MessageResource CLB_FILE = new MessageResource(JFaceMenuManager.class, "clbFile");
    private static final MessageResource CLB_NEW_FILE = new MessageResource(JFaceMenuManager.class, "clbNewFile");
    private static final MessageResource CLB_GAME = new MessageResource(JFaceMenuManager.class, "clbGame");
    private static final MessageResource CLB_PROBLEM = new MessageResource(JFaceMenuManager.class, "clbProblem");
    private static final MessageResource CLB_SIZE_19 = new MessageResource(JFaceMenuManager.class, "clbSize.19");
    private static final MessageResource CLB_SIZE_13 = new MessageResource(JFaceMenuManager.class, "clbSize.13");
    private static final MessageResource CLB_SIZE_9 = new MessageResource(JFaceMenuManager.class, "clbSize.9");
    private static final MessageResource CLB_TRASH_CAN = new MessageResource(JFaceMenuManager.class, "clbTrashCan");
    private static final MessageResource CLB_EDIT = new MessageResource(JFaceMenuManager.class, "clbEdit");
    private static final MessageResource CLB_POSITION = new MessageResource(JFaceMenuManager.class, "clbPosition");
    private static final MessageResource CLB_MOVE = new MessageResource(JFaceMenuManager.class, "clbMove");
    private static final MessageResource CLB_CURRENT_RGT1 = new MessageResource(JFaceMenuManager.class, "clbCurrentRgt1");
    private static final MessageResource CLB_CURRENT_RGT2 = new MessageResource(JFaceMenuManager.class, "clbCurrentRgt2");
    private static final MessageResource CLB_VIEW = new MessageResource(JFaceMenuManager.class, "clbView");
    private static final MessageResource CLB_LAYOUT = new MessageResource(JFaceMenuManager.class, "clbLayout");
    private static final MessageResource CLB_TOOL = new MessageResource(JFaceMenuManager.class, "clbTool");
    private static final MessageResource CLB_HELP = new MessageResource(JFaceMenuManager.class, "clbHelp");
    private static final ProviderInfo[] providerInfos_s_ = new ProviderInfo[]{new ProviderInfo(CoordinatesLabelProvider.class, CoordinatesLabelProvider.CONTEXT.displayName()), new ProviderInfo(StonePainter.class, StonePainter.CONTEXT.displayName()), new ProviderInfo(BlockLabelProvider.class, BlockLabelProvider.CONTEXT.displayName()), new ProviderInfo(VariationLabelProvider.class, VariationLabelProvider.CONTEXT.displayName())};
    private final JFaceWindow window_;
    private final Map<Class, Action> providerMap_;
    private final Map<Class, MenuManager> providerInterfaceMenuMap_;
    private final Adapter adapter_;
    private MenuManager editMenu_;
    private MenuManager rgtEditMenu_;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    public JFaceMenuManager(JFaceWindow window) {
        ArgumentChecker.throwIfNull((Object)window);
        this.window_ = window;
        this.providerMap_ = new HashMap<Class, Action>();
        this.providerInterfaceMenuMap_ = new HashMap<Class, MenuManager>();
        this.adapter_ = new Adapter();
        window.addListener(this.adapter_);
    }

    @Override
    public Object getAdapter(Class<?> adapter) {
        if (adapter == null) {
            return null;
        }
        if (adapter.isAssignableFrom(this.adapter_.getClass())) {
            return this.adapter_;
        }
        return null;
    }

    public void initialize() {
    }

    public void createMenu(MenuManager menuManager) {
        this.createFileMenu(menuManager);
        this.createEditMenu(menuManager);
        this.createViewMenu(menuManager);
        this.createToolMenu(menuManager);
        this.createHelpMenu(menuManager);
    }

    private void createFileMenu(MenuManager menuManager) {
        MenuManager fileMenu = new MenuManager(CLB_FILE.get());
        this.createNewFileMenu(fileMenu);
        fileMenu.add(new Separator());
        fileMenu.add(new OpenFileAction().setController(this.window_));
        fileMenu.add(new OpenFromClipboard().setController(this.window_));
        fileMenu.add(new CloseTabAction(this.window_));
        fileMenu.add(new CloseAllTabAction(this.window_));
        fileMenu.add(new Separator());
        fileMenu.add(new SaveAction().setController(this.window_));
        fileMenu.add(new SaveAsAction().setController(this.window_));
        fileMenu.add(new Separator());
        this.createTrashCanMenu(fileMenu);
        fileMenu.add(new Separator());
        fileMenu.add(new CreateWindowAction());
        fileMenu.add(new Separator());
        fileMenu.add(new ExitAction());
        menuManager.add(fileMenu);
    }

    private void createNewFileMenu(MenuManager parent) {
        MenuManager menu = new MenuManager(CLB_NEW_FILE.get());
        this.createNewGameFileMenu(menu);
        this.createNewProblemFileMenu(menu);
        menu.add(new NewDrillFileAction().setController(this.window_));
        parent.add(menu);
    }

    private void createNewGameFileMenu(MenuManager parent) {
        MenuManager menu = new MenuManager(CLB_GAME.get());
        MenuManager submenu = new MenuManager(CLB_SIZE_19.get());
        this.createNewGameFileAndHandicapMenu(submenu, SgfSize.create(19, 19), 9);
        menu.add(submenu);
        submenu = new MenuManager(CLB_SIZE_13.get());
        this.createNewGameFileAndHandicapMenu(submenu, SgfSize.create(13, 13), 6);
        menu.add(submenu);
        submenu = new MenuManager(CLB_SIZE_9.get());
        this.createNewGameFileAndHandicapMenu(submenu, SgfSize.create(9, 9), 4);
        menu.add(submenu);
        parent.add(menu);
    }

    private void createNewGameFileAndHandicapMenu(MenuManager parent, SgfSize sgfSize, int maxHandicap) {
        int i = 0;
        while (i <= maxHandicap) {
            parent.add(new NewGameFileAction(sgfSize, i).setController(this.window_));
            ++i;
        }
    }

    private void createNewProblemFileMenu(MenuManager parent) {
        MenuManager menu = new MenuManager(CLB_PROBLEM.get());
        MenuManager submenu = new MenuManager(CLB_SIZE_19.get());
        this.createNewProblemFileAndPlayerToPlayMenu(submenu, SgfSize.create(19, 19));
        menu.add(submenu);
        submenu = new MenuManager(CLB_SIZE_13.get());
        this.createNewProblemFileAndPlayerToPlayMenu(submenu, SgfSize.create(13, 13));
        menu.add(submenu);
        submenu = new MenuManager(CLB_SIZE_9.get());
        this.createNewProblemFileAndPlayerToPlayMenu(submenu, SgfSize.create(9, 9));
        menu.add(submenu);
        parent.add(menu);
    }

    private void createNewProblemFileAndPlayerToPlayMenu(MenuManager parent, SgfSize sgfSize) {
        parent.add(new NewProblemFileAction(sgfSize, SgfColor.BLACK).setController(this.window_));
        parent.add(new NewProblemFileAction(sgfSize, SgfColor.WHITE).setController(this.window_));
    }

    private void createTrashCanMenu(MenuManager parent) {
        MenuManager menu = new MenuManager(CLB_TRASH_CAN.get());
        menu.add(new SalvageFromTrashCanAction(this.window_));
        menu.add(new ClearTrashCanAction(this.window_));
        parent.add(menu);
    }

    private void createEditMenu(MenuManager menuManager) {
        this.editMenu_ = new MenuManager(CLB_EDIT.get());
        this.editMenu_.add(new UndoAction().setController(this.window_));
        this.editMenu_.add(new RedoAction().setController(this.window_));
        this.editMenu_.add(new Separator());
        this.createPositionValueMenu(this.editMenu_);
        this.createMoveValueMenu(this.editMenu_);
        this.editMenu_.add(new ClearPlPropertyAction().setController(this.window_));
        this.editMenu_.add(new RemoveNodeAction().setController(this.window_));
        this.editMenu_.add(new Separator());
        this.editMenu_.add(new SetVwAtRootAction(this.window_));
        this.editMenu_.add(new UnsetVwAtRootAction(this.window_));
        this.editMenu_.add(new Separator());
        this.createRootGameTreeEditMenu(this.editMenu_);
        this.editMenu_.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                JFaceMenuManager.this.updateMenu();
            }
        });
        menuManager.add(this.editMenu_);
    }

    private void createPositionValueMenu(MenuManager parent) {
        MenuManager menu = new MenuManager(CLB_POSITION.get());
        menu.add(new SetPositionValueAction(this.window_, SgfId.GOOD_FOR_WHITE.makeProperty(SgfDouble.EMPHASIZED)));
        menu.add(new SetPositionValueAction(this.window_, SgfId.GOOD_FOR_WHITE.makeProperty(SgfDouble.NORMAL)));
        menu.add(new SetPositionValueAction(this.window_, SgfId.GOOD_FOR_BLACK.makeProperty(SgfDouble.EMPHASIZED)));
        menu.add(new SetPositionValueAction(this.window_, SgfId.GOOD_FOR_BLACK.makeProperty(SgfDouble.NORMAL)));
        menu.add(new SetPositionValueAction(this.window_, SgfId.EVEN_POSITION.makeProperty(SgfDouble.EMPHASIZED)));
        menu.add(new SetPositionValueAction(this.window_, SgfId.EVEN_POSITION.makeProperty(SgfDouble.NORMAL)));
        menu.add(new SetPositionValueAction(this.window_, SgfId.UNCLEAR_POS.makeProperty(SgfDouble.EMPHASIZED)));
        menu.add(new SetPositionValueAction(this.window_, SgfId.UNCLEAR_POS.makeProperty(SgfDouble.NORMAL)));
        menu.add(new Separator());
        menu.add(new SetPositionValueAction(this.window_, SgfId.HOTSPOT.makeProperty(SgfDouble.EMPHASIZED)));
        menu.add(new SetPositionValueAction(this.window_, SgfId.HOTSPOT.makeProperty(SgfDouble.NORMAL)));
        menu.add(new Separator());
        menu.add(new SetPositionValueAction(this.window_, null));
        parent.add(menu);
    }

    private void createMoveValueMenu(MenuManager parent) {
        MenuManager menu = new MenuManager(CLB_MOVE.get());
        menu.add(new SetMoveValueAction(this.window_, SgfId.TESUJI.makeProperty(SgfDouble.EMPHASIZED)));
        menu.add(new SetMoveValueAction(this.window_, SgfId.TESUJI.makeProperty(SgfDouble.NORMAL)));
        menu.add(new SetMoveValueAction(this.window_, SgfId.BAD_MOVE.makeProperty(SgfDouble.EMPHASIZED)));
        menu.add(new SetMoveValueAction(this.window_, SgfId.BAD_MOVE.makeProperty(SgfDouble.NORMAL)));
        menu.add(new SetMoveValueAction(this.window_, SgfId.INTERESTING.makeProperty(None.INSTANCE)));
        menu.add(new SetMoveValueAction(this.window_, SgfId.DOUBTFUL.makeProperty(None.INSTANCE)));
        menu.add(new Separator());
        menu.add(new SetMoveValueAction(this.window_, null));
        parent.add(menu);
    }

    private void createRootGameTreeEditMenu(MenuManager parent) {
        this.rgtEditMenu_ = new MenuManager(CLB_CURRENT_RGT1.get());
        this.rgtEditMenu_.add(new CopyRootGameTreeAction(this.window_));
        this.rgtEditMenu_.add(new MoveRootGameTreeAction(this.window_));
        this.rgtEditMenu_.add(new RemoveRootGameTreeAction(this.window_));
        parent.add(this.rgtEditMenu_);
    }

    private void createViewMenu(MenuManager menuManager) {
        MenuManager viewMenu = new MenuManager(CLB_VIEW.get());
        ProviderInfo[] providerInfoArray = providerInfos_s_;
        int n = 0;
        int n2 = providerInfoArray.length;
        while (n < n2) {
            ProviderInfo info = providerInfoArray[n];
            this.composeProviderMenu(viewMenu, info.clazz_, info.displayName_);
            ++n;
        }
        viewMenu.add(new Separator());
        viewMenu.add(this.createLayoutMenu());
        viewMenu.add(new ShowSgfText(this.window_));
        viewMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                JFaceMenuManager.this.updateMenu();
            }
        });
        menuManager.add(viewMenu);
    }

    private <T extends Provider> void composeProviderMenu(MenuManager parentMenu, Class<T> clazz, String displayName) {
        MenuManager menuManager = new MenuManager(displayName);
        this.providerInterfaceMenuMap_.put(clazz, menuManager);
        Provider[] providerArray = Yukinoshita.context().getProviders(clazz);
        int n = 0;
        int n2 = providerArray.length;
        while (n < n2) {
            Provider provider = providerArray[n];
            SelectProviderAction<Provider> action = new SelectProviderAction<Provider>(clazz, provider);
            action.setController(this.window_);
            menuManager.add(action);
            this.providerMap_.put(provider.getClass(), action);
            ++n;
        }
        parentMenu.add(menuManager);
    }

    private MenuManager createLayoutMenu() {
        MenuManager menuManager = new MenuManager(CLB_LAYOUT.get());
        menuManager.add(new LoadLayoutAction(this.window_));
        menuManager.add(new DefaultLayoutAction(this.window_));
        menuManager.add(new Separator());
        menuManager.add(new SaveLayoutAction(this.window_));
        return menuManager;
    }

    private void createToolMenu(MenuManager menuManager) {
        MenuManager fileMenu = new MenuManager(CLB_TOOL.get());
        fileMenu.add(new OpenPreferenceAction((JFaceContext)Yukinoshita.context()));
        menuManager.add(fileMenu);
    }

    private void createHelpMenu(MenuManager menuManager) {
        MenuManager fileMenu = new MenuManager(CLB_HELP.get());
        fileMenu.add(new AboutAction());
        menuManager.add(fileMenu);
    }

    private void updateMenu() {
        String label;
        GameFrameController gfc = this.window_.getActive();
        MenuItem menuItem = this.rgtEditMenu_.getMenu().getParentItem();
        if (gfc == null) {
            menuItem.setText("\u30d5\u30a1\u30a4\u30eb\u304c\u3042\u308a\u307e\u305b\u3093");
            menuItem.setEnabled(false);
            return;
        }
        GameMediator gameMediator = gfc.getCollectionEditor().getActiveGame();
        RootGameTree rgt = gameMediator.getRootGameTree();
        RootGameTreeLabelProvider provider = RootGameTreeLabelProvider.CONTEXT.defaultProvider();
        String name = provider.getLabel(rgt);
        if (name.length() != 0) {
            label = CLB_CURRENT_RGT2.get(rgt.getGameType().displayName(), name);
        } else {
            provider = new GreedyRgtLabelProvider();
            name = provider.getLabel(rgt);
            label = CLB_CURRENT_RGT1.get((Object)name);
        }
        menuItem.setText(label);
        menuItem.setEnabled(true);
        ProviderInfo[] providerInfoArray = providerInfos_s_;
        int n = 0;
        int n2 = providerInfoArray.length;
        while (n < n2) {
            ProviderInfo info = providerInfoArray[n];
            this.changeRadioState(gfc, info.clazz_);
            ++n;
        }
    }

    private <T extends Provider> void changeRadioState(GameFrameController gfc, Class<T> clazz) {
        IAction action = this.providerMap_.get(gfc.getProvider(clazz).getClass());
        IContributionItem[] items = this.providerInterfaceMenuMap_.get(clazz).getItems();
        int i = 0;
        while (i < items.length) {
            ((ActionContributionItem)items[i]).getAction().setChecked(false);
            ++i;
        }
        if (action != null) {
            action.setChecked(true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ProviderInfo {
        private final Class<? extends Provider> clazz_;
        private final String displayName_;

        ProviderInfo(Class<? extends Provider> clazz, String displayName) {
            this.clazz_ = clazz;
            this.displayName_ = displayName;
        }
    }

    private class Adapter
    implements ModelEventNotifier,
    ControllerStatusViewer,
    NodeViewer,
    WindowControllerListener {
        private EventBroker eventBroker_ = EventBroker.NULL_BROKER;

        Adapter() {
        }

        public void setEventBroker(EventBroker eventBroker) {
            ArgumentChecker.throwIfNull((Object)eventBroker);
            this.eventBroker_.removeView(JFaceMenuManager.this);
            this.eventBroker_ = eventBroker;
            this.eventBroker_.addView(JFaceMenuManager.this);
        }

        public void setEditMode(boolean isEditMode) {
        }

        public void changeHandlerPhase(HandlerPhase phase) {
        }

        public void update(NodeView nodeView) {
            JFaceMenuManager.this.updateMenu();
        }

        public void changeActive(GameFrameController now) {
            JFaceMenuManager.this.updateMenu();
        }
    }
}

