/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.act;

import java.util.EnumSet;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Display;
import org.unitarou.ml.BasicMessages;
import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.type.Application;
import org.unitarou.sgf.type.SgfColor;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.util.RootGameTreeFactory;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.model.CollectionEditor;
import org.unitarou.yukinoshita.view.CollectionViewer;
import org.unitarou.yukinoshita.view.GameFrameController;
import org.unitarou.yukinoshita.view.WindowController;
import org.unitarou.yukinoshita.view.cmd.ChangeEditModeCommand;
import org.unitarou.yukinoshita.view.cmd.GameChangeCommand;
import org.unitarou.yukinoshita.view.jface.dlg.SelectTargetFileDialog;

public class NewProblemFileAction
extends Action {
    private final SgfSize sgfSize_;
    private final SgfColor playerToPlay_;
    private static final MessageResource CLB_NAME = new MessageResource(NewProblemFileAction.class, "clbName");
    private WindowController controller_;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public NewProblemFileAction(SgfSize sgfSize, SgfColor playerToPlay) {
        ArgumentChecker.throwIfNull((Object)sgfSize, (Object)playerToPlay);
        this.sgfSize_ = sgfSize;
        this.playerToPlay_ = playerToPlay;
        this.controller_ = null;
        this.setText(CLB_NAME.get((Object)this.playerToPlay_.displayName()));
    }

    public NewProblemFileAction setController(WindowController controller) {
        ArgumentChecker.throwIfNull((Object)controller);
        this.controller_ = controller;
        return this;
    }

    public void run() {
        RootGameTree newRgt = RootGameTreeFactory.createProblem(this.sgfSize_, this.playerToPlay_);
        newRgt.setApplication(Application.create(Yukinoshita.instance().getName(), Yukinoshita.instance().getVersion()));
        GameFrameController target = null;
        if (this.controller_.getGameFrameControllers().length != 0) {
            SelectTargetFileDialog dialog = new SelectTargetFileDialog(Display.getCurrent().getActiveShell(), EnumSet.of(SelectTargetFileDialog.Type.PERMITS_NEW_FILE, SelectTargetFileDialog.Type.PERMITS_PROBLEM));
            dialog.setShellTitle("\u8a70\u7881\u306e\u65b0\u898f\u4f5c\u6210");
            dialog.setTitle("\u8a70\u7881\u306e\u8ffd\u52a0\u5148\u3092\u6307\u5b9a\u3057\u3066\u4e0b\u3055\u3044\u3002");
            int ret = dialog.open();
            if (ret == 1) {
                return;
            }
            target = dialog.getTarget();
        }
        if (target == null) {
            Collection collection = new Collection();
            collection.addLast(newRgt);
            this.controller_.register(collection, BasicMessages.LB_NEW_FILE.get(), false);
            this.controller_.getActive().getEventBroker().executeCommand(new ChangeEditModeCommand(true));
            return;
        }
        CollectionEditor editor = target.getCollectionEditor();
        editor.createGame(newRgt);
        for (CollectionViewer viewer : target.getEventBroker().getListeners(CollectionViewer.class)) {
            viewer.update(editor);
        }
        GameChangeCommand command = new GameChangeCommand(editor.size() - 1);
        target.getEventBroker().executeCommand(command);
    }
}

