/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.act;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Display;
import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.Collection;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.Application;
import org.unitarou.yukinoshita.FileManager;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.view.WindowController;
import org.unitarou.yukinoshita.view.jface.dlg.IgoFileChooser;
import org.unitarou.yukinoshita.view.jface.dlg.IgoFileDialog;

public class OpenFileAction
extends Action {
    private static final Log log_s_ = LogFactory.getLog(OpenFileAction.class);
    private static final MessageResource CLB_NAME = new MessageResource(OpenFileAction.class, "clbName");
    private static final MessageResource NT_FILE_READ_FAILURE = new MessageResource(OpenFileAction.class, "ntFileReadFailure");
    private static final MessageResource MSG_GAME_NOT_FOUND = new MessageResource(OpenFileAction.class, "msgGameNotFound");
    private WindowController controller_ = null;
    static /* synthetic */ Class class$0;

    public OpenFileAction() {
        this.setText(CLB_NAME.get());
    }

    public OpenFileAction setController(WindowController controller) {
        ArgumentChecker.throwIfNull((Object)controller);
        this.controller_ = controller;
        return this;
    }

    public void run() {
        if (this.controller_ == null) {
            log_s_.warn("#setController(...) hasn't call yet. #run() call is ignored.");
            return;
        }
        IgoFileDialog dialog = new IgoFileDialog(Display.getCurrent().getActiveShell(), IgoFileChooser.Style.OPEN_FILES);
        dialog.open();
        File[] fileArray = dialog.getFiles();
        int n = 0;
        int n2 = fileArray.length;
        while (n < n2) {
            File file = fileArray[n];
            if (!Yukinoshita.instance().checkFreeMemory()) {
                return;
            }
            this.openFileImpl(file);
            ++n;
        }
    }

    private void openFileImpl(File file) {
        Collection collection = FileManager.instance().open(file);
        if (collection.size() == 0) {
            String msg = MSG_GAME_NOT_FOUND.get((Object)file);
            log_s_.info(msg);
            Yukinoshita.application().openMessageDialog(Application.MessageLevel.INFORMATION, NT_FILE_READ_FAILURE.get(), msg);
            return;
        }
        this.controller_.register(collection, null, false);
    }
}

