/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.act;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.Action;
import org.unitarou.cmd.Command;
import org.unitarou.cmd.RedoUndoController;
import org.unitarou.ml.MessageResource;
import org.unitarou.util.Adaptable;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.events.WindowControllerListener;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.model.cmd.Command4NodeList;
import org.unitarou.yukinoshita.view.ControllerStatusViewer;
import org.unitarou.yukinoshita.view.GameFrameController;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.NodeViewer;
import org.unitarou.yukinoshita.view.WindowController;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RedoAction
extends Action
implements Adaptable {
    private static final Log log_s_ = LogFactory.getLog(RedoAction.class);
    private static final MessageResource CLB_NAME = new MessageResource(RedoAction.class, "clbName");
    private final Adapter adapter_ = new Adapter();
    private WindowController controller_ = null;
    static /* synthetic */ Class class$0;

    public RedoAction() {
        this.setCommandName("");
        this.setEnabled(false);
    }

    @Override
    public Object getAdapter(Class<?> adapter) {
        if (adapter == null) {
            return null;
        }
        if (adapter.isAssignableFrom(this.adapter_.getClass())) {
            return this.adapter_;
        }
        return null;
    }

    private void setCommandName(String redoName) {
        this.setText(CLB_NAME.get((Object)redoName));
    }

    public RedoAction setController(WindowController controller) {
        ArgumentChecker.throwIfNull((Object)controller);
        if (this.controller_ != null) {
            this.controller_.removListener(this.adapter_);
        }
        this.controller_ = controller;
        this.controller_.addListener(this.adapter_);
        return this;
    }

    @Override
    public void run() {
        if (this.controller_ == null) {
            log_s_.warn("#setController(...) hasn't call yet. #run() call is ignored.");
            return;
        }
        GameFrameController gfc = this.controller_.getActive();
        RedoUndoController controller = gfc.getActiveRedoUndoController();
        Command command = controller.redo();
        if (command instanceof Command4NodeList) {
            gfc.updateByRedoUndo(((Command4NodeList)command).getInfluence());
        }
    }

    private class Adapter
    implements NodeViewer,
    ControllerStatusViewer,
    WindowControllerListener {
        private Reference<GameFrameController> refGfc_ = new WeakReference<Object>(null);

        Adapter() {
        }

        public void update(NodeView nodeView) {
            GameFrameController gfc = this.refGfc_.get();
            if (gfc != null) {
                RedoUndoController ruc = gfc.getActiveRedoUndoController();
                RedoAction.this.setEnabled(gfc.isEditMode() && ruc.isRedoable());
                RedoAction.this.setCommandName(ruc.getRedoName());
            }
        }

        public void changeActive(GameFrameController now) {
            GameFrameController last = this.refGfc_.get();
            if (last != null) {
                last.getEventBroker().removeView(RedoAction.this);
            }
            this.refGfc_ = new WeakReference<GameFrameController>(now);
            if (now == null) {
                RedoAction.this.setEnabled(false);
                RedoAction.this.setCommandName("");
                return;
            }
            now.getEventBroker().addView(RedoAction.this);
            RedoUndoController ruc = now.getActiveRedoUndoController();
            RedoAction.this.setEnabled(now.isEditMode() && ruc.isRedoable());
            RedoAction.this.setCommandName(ruc.getRedoName());
        }

        public void setEditMode(boolean isEditMode) {
            GameFrameController now = this.refGfc_.get();
            if (now == null) {
                log_s_.warn("Lost GameFraemController (BUG)");
                return;
            }
            if (isEditMode) {
                RedoUndoController ruc = now.getActiveRedoUndoController();
                RedoAction.this.setEnabled(ruc.isRedoable());
                RedoAction.this.setCommandName(ruc.getRedoName());
            } else {
                RedoAction.this.setEnabled(false);
                RedoAction.this.setCommandName("");
            }
        }

        public void changeHandlerPhase(HandlerPhase phase) {
        }
    }
}

