/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.act;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.Action;
import org.unitarou.ml.MessageResource;
import org.unitarou.util.Adaptable;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.events.WindowControllerListener;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.model.cmd.RemoveCurrentNode;
import org.unitarou.yukinoshita.view.ControllerStatusViewer;
import org.unitarou.yukinoshita.view.GameFrameController;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.NodeViewer;
import org.unitarou.yukinoshita.view.WindowController;
import org.unitarou.yukinoshita.view.provider.nlp.NodeViewLabelProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoveNodeAction
extends Action
implements Adaptable {
    private static final Log log_s_ = LogFactory.getLog(RemoveNodeAction.class);
    private static final MessageResource CLB_NAME = new MessageResource(RemoveNodeAction.class, "clbName");
    private final Adapter adapter_ = new Adapter();
    private WindowController controller_ = null;
    static /* synthetic */ Class class$0;

    public RemoveNodeAction() {
        this.setCommandName("");
        this.setEnabled(false);
    }

    @Override
    public Object getAdapter(Class<?> adapter) {
        if (adapter == null) {
            return null;
        }
        if (adapter.isAssignableFrom(this.adapter_.getClass())) {
            return this.adapter_;
        }
        return null;
    }

    private void setCommandName(String name) {
        String param = name.trim();
        if (param.length() != 0) {
            param = String.valueOf('(') + param + ')';
        }
        this.setText(CLB_NAME.get((Object)param));
    }

    public RemoveNodeAction setController(WindowController controller) {
        ArgumentChecker.throwIfNull((Object)controller);
        if (this.controller_ != null) {
            this.controller_.removListener(this.adapter_);
        }
        this.controller_ = controller;
        this.controller_.addListener(this.adapter_);
        return this;
    }

    @Override
    public void run() {
        this.controller_.getActive().getEventBroker().executeCommand(new RemoveCurrentNode());
    }

    private class Adapter
    implements NodeViewer,
    ControllerStatusViewer,
    WindowControllerListener {
        private Reference<GameFrameController> refGfc_ = new WeakReference<Object>(null);

        Adapter() {
        }

        public void update(NodeView nodeView) {
            GameFrameController gfc = this.refGfc_.get();
            if (gfc == null) {
                log_s_.warn("Lost GameFrameController (BUG)");
                return;
            }
            ArgumentChecker.throwIfNull((Object)nodeView);
            RemoveNodeAction.this.setCommandName(NodeViewLabelProvider.CONTEXT.defaultProvider().getLabel(nodeView));
            RemoveNodeAction.this.setEnabled(this.isValidState(gfc));
        }

        public void changeActive(GameFrameController now) {
            GameFrameController last = this.refGfc_.get();
            if (last != null) {
                last.getEventBroker().removeView(RemoveNodeAction.this);
            }
            this.refGfc_ = new WeakReference<GameFrameController>(now);
            GameFrameController gfc = this.refGfc_.get();
            if (gfc != null) {
                now.getEventBroker().addView(RemoveNodeAction.this);
            }
            if (!this.isValidState(gfc)) {
                RemoveNodeAction.this.setEnabled(false);
                RemoveNodeAction.this.setCommandName("");
                return;
            }
            RemoveNodeAction.this.setEnabled(true);
        }

        private boolean isValidState(GameFrameController gfc) {
            if (gfc == null) {
                return false;
            }
            if (gfc.getCollectionEditor().getActiveGame().getNodeList().size() <= 1) {
                return false;
            }
            return gfc.isEditMode();
        }

        public void setEditMode(boolean isEditMode) {
            RemoveNodeAction.this.setEnabled(isEditMode);
        }

        public void changeHandlerPhase(HandlerPhase phase) {
        }
    }
}

