/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.act;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.unitarou.io.Ios;
import org.unitarou.ml.BasicMessages;
import org.unitarou.ml.MessageResource;
import org.unitarou.util.Adaptable;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.FileManager;
import org.unitarou.yukinoshita.YukinoshitaException;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.events.WindowControllerListener;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.model.cmd.ChangeFileName;
import org.unitarou.yukinoshita.view.GameFrameController;
import org.unitarou.yukinoshita.view.NodeViewer;
import org.unitarou.yukinoshita.view.WindowController;
import org.unitarou.yukinoshita.view.jface.dlg.IgoFileDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SaveAction
extends Action
implements Adaptable {
    private static final Log log_s_ = LogFactory.getLog(SaveAction.class);
    private static final MessageResource CLB_Name = new MessageResource(SaveAction.class, "clbName");
    private WindowController controller_ = null;
    private final Adapter adapter_ = new Adapter();
    static /* synthetic */ Class class$0;

    public SaveAction() {
        this.setText(CLB_Name.get());
        this.setEnabled(false);
    }

    @Override
    public Object getAdapter(Class<?> adapter) {
        if (adapter == null) {
            return null;
        }
        if (adapter.isAssignableFrom(this.adapter_.getClass())) {
            return this.adapter_;
        }
        return null;
    }

    public SaveAction setController(WindowController controller) {
        ArgumentChecker.throwIfNull((Object)controller);
        this.controller_ = controller;
        this.controller_.addListener(this.adapter_);
        return this;
    }

    @Override
    public void run() {
        if (this.controller_ == null) {
            log_s_.warn("#setController(...) hasn't call yet. #run() call is ignored.");
            return;
        }
        Control focused = Display.getCurrent().getFocusControl();
        focused.getParent().forceFocus();
        focused.forceFocus();
        GameFrameController gfc = this.controller_.getActive();
        if (gfc.getCollection().getFile() == null || Ios.isTemporaryFile(gfc.getCollection().getFile())) {
            File newFile = IgoFileDialog.askSaveFile(gfc.getCollection().getFile());
            if (newFile == null) {
                return;
            }
            this.controller_.getActive().getEventBroker().executeCommand(new ChangeFileName(gfc.getCollection(), newFile));
        }
        try {
            FileManager.instance().save(gfc.getCollection());
            gfc.clearChangedFlag();
        }
        catch (YukinoshitaException e) {
            gfc.getCollection().setFile(null);
            log_s_.error(BasicMessages.NT_FILE_SAVE_FAILURE.get(), e);
            MessageDialog.openError(Display.getCurrent().getActiveShell(), BasicMessages.NT_FILE_SAVE_FAILURE.get(), e.getLocalizedMessage());
        }
    }

    private class Adapter
    implements WindowControllerListener,
    NodeViewer {
        private EventBroker eventBroker_ = EventBroker.NULL_BROKER;
        private GameFrameController gfc_ = null;

        Adapter() {
        }

        public void changeActive(GameFrameController now) {
            this.eventBroker_.removeView(SaveAction.this);
            if (now != null) {
                now.getEventBroker().addView(SaveAction.this);
                SaveAction.this.setEnabled(now.isChanged());
            } else {
                this.eventBroker_ = EventBroker.NULL_BROKER;
                SaveAction.this.setEnabled(false);
            }
            this.gfc_ = now;
        }

        public void update(NodeView nodeView) {
            ArgumentChecker.throwIfNull((Object)nodeView);
            SaveAction.this.setEnabled(this.gfc_.isChanged());
        }
    }
}

