/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.act;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.unitarou.ml.BasicMessages;
import org.unitarou.ml.MessageResource;
import org.unitarou.util.Adaptable;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.FileManager;
import org.unitarou.yukinoshita.YukinoshitaException;
import org.unitarou.yukinoshita.events.WindowControllerListener;
import org.unitarou.yukinoshita.model.cmd.ChangeFileName;
import org.unitarou.yukinoshita.view.GameFrameController;
import org.unitarou.yukinoshita.view.WindowController;
import org.unitarou.yukinoshita.view.jface.dlg.IgoFileDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SaveAsAction
extends Action
implements Adaptable {
    private static final Log log_s_ = LogFactory.getLog(SaveAsAction.class);
    private static final MessageResource CLB_Name = new MessageResource(SaveAsAction.class, "clbName");
    private WindowController controller_ = null;
    private final Adapter adapter_ = new Adapter();
    static /* synthetic */ Class class$0;

    public SaveAsAction() {
        this.setText(CLB_Name.get());
        this.setEnabled(false);
    }

    @Override
    public Object getAdapter(Class<?> adapter) {
        if (adapter == null) {
            return null;
        }
        if (adapter.isAssignableFrom(this.adapter_.getClass())) {
            return this.adapter_;
        }
        return null;
    }

    public SaveAsAction setController(WindowController controller) {
        ArgumentChecker.throwIfNull((Object)controller);
        this.controller_ = controller;
        this.controller_.addListener(this.adapter_);
        return this;
    }

    @Override
    public void run() {
        if (this.controller_ == null) {
            log_s_.warn("#setController(...) hasn't call yet. #run() call is ignored.");
            return;
        }
        Control focused = Display.getCurrent().getFocusControl();
        focused.getParent().forceFocus();
        focused.forceFocus();
        GameFrameController gfc = this.controller_.getActive();
        File file = IgoFileDialog.askSaveFile(gfc.getCollection().getFile());
        if (file == null) {
            return;
        }
        this.controller_.getActive().getEventBroker().executeCommand(new ChangeFileName(gfc.getCollection(), file));
        try {
            FileManager.instance().save(gfc.getCollection());
            gfc.clearChangedFlag();
        }
        catch (YukinoshitaException e) {
            log_s_.error(BasicMessages.NT_FILE_SAVE_FAILURE.get(), e);
            MessageDialog.openError(Display.getCurrent().getActiveShell(), BasicMessages.NT_FILE_SAVE_FAILURE.get(), e.getLocalizedMessage());
        }
    }

    private class Adapter
    implements WindowControllerListener {
        Adapter() {
        }

        public void changeActive(GameFrameController now) {
            SaveAsAction.this.setEnabled(now != null);
        }
    }
}

