/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.act;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.Action;
import org.unitarou.sgf.type.GameType;
import org.unitarou.sgf.util.provider.crdlp.CoordinatesLabelProvider;
import org.unitarou.util.Adaptable;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.util.Provider;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.events.WindowControllerListener;
import org.unitarou.yukinoshita.view.ControllerStatusViewer;
import org.unitarou.yukinoshita.view.GameFrameController;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.WindowController;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectProviderAction<T extends Provider>
extends Action
implements Adaptable {
    private static final Log log_s_ = LogFactory.getLog(SelectProviderAction.class);
    private final T provider_;
    private final Class<T> providerInterface_;
    private WindowController controller_;
    private final Adapter adapter_;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public SelectProviderAction(Class<T> providerInterface, T provider) {
        super("", 8);
        ArgumentChecker.throwIfNull(providerInterface, provider);
        if (!providerInterface.isAssignableFrom(provider.getClass())) {
            throw new IllegalArgumentException("provider: " + provider + " must be subclass of " + providerInterface);
        }
        this.adapter_ = new Adapter();
        this.providerInterface_ = providerInterface;
        this.provider_ = provider;
        this.setText(this.provider_.displayName());
        CoordinatesLabelProvider currentProvider = Yukinoshita.context().getProvider(CoordinatesLabelProvider.class, null);
        this.setChecked(provider.equals(currentProvider));
        this.setEnabled(false);
    }

    @Override
    public void run() {
        if (this.controller_ == null) {
            log_s_.warn("#setController(...) hasn't call yet. #run() call is ignored.");
            return;
        }
        this.controller_.getActive().changeProvider(this.providerInterface_, (Provider)this.provider_);
    }

    @Override
    public Object getAdapter(Class<?> adapter) {
        if (adapter == null) {
            return null;
        }
        if (adapter.isAssignableFrom(this.adapter_.getClass())) {
            return this.adapter_;
        }
        return null;
    }

    public SelectProviderAction setController(WindowController controller) {
        ArgumentChecker.throwIfNull((Object)controller);
        if (this.controller_ != null) {
            this.controller_.removListener(this.adapter_);
        }
        this.controller_ = controller;
        this.controller_.addListener(this.adapter_);
        return this;
    }

    private class Adapter
    implements WindowControllerListener,
    ControllerStatusViewer {
        private GameFrameController gfc_ = null;

        Adapter() {
        }

        public void changeActive(GameFrameController now) {
            if (this.gfc_ != null) {
                this.gfc_.getEventBroker().removeView(SelectProviderAction.this);
            }
            this.gfc_ = now;
            this.updateEnableStatus();
        }

        public void setEditMode(boolean isEditMode) {
            this.updateEnableStatus();
        }

        public void changeHandlerPhase(HandlerPhase phase) {
        }

        private void updateEnableStatus() {
            if (this.gfc_ == null) {
                SelectProviderAction.this.setEnabled(false);
            } else {
                this.gfc_.getEventBroker().addView(SelectProviderAction.this);
                GameType gameType = this.gfc_.getCollectionEditor().getActiveGame().getGameType();
                SelectProviderAction.this.setEnabled(this.gfc_.isEditMode() || !GameType.PROBLEM.equals(gameType));
            }
        }
    }
}

