/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.act;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.unitarou.ml.BasicMessages;
import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.ValueType;
import org.unitarou.sgf.type.GameType;
import org.unitarou.sgf.type.SgfDouble;
import org.unitarou.sgf.util.provider.plp.BasicPropertyLabelProvider;
import org.unitarou.sgf.util.provider.plp.PropertyLabelProvider;
import org.unitarou.util.Adaptable;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.events.WindowControllerListener;
import org.unitarou.yukinoshita.model.GameMediator;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.model.cmd.UpdateProperty;
import org.unitarou.yukinoshita.view.ControllerStatusViewer;
import org.unitarou.yukinoshita.view.GameFrameController;
import org.unitarou.yukinoshita.view.GameViewer;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.NodeViewer;
import org.unitarou.yukinoshita.view.WindowController;
import org.unitarou.yukinoshita.view.jface.act.AbstractAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetPositionValueAction
extends AbstractAction
implements Adaptable {
    private static final Set<Property> exclusives_s_;
    private static final MessageResource LB_ADD;
    private static final MessageResource LB_REMOVE;
    private static final MessageResource CLB_NO_VALUE;
    private final Adapter adapter_ = new Adapter();
    private final Property property_;
    private PropertyLabelProvider provider_;
    private final Property[] exclusives_;
    private GameType gameType_;
    private boolean isAddMode_;
    static /* synthetic */ Class class$0;

    static {
        ArrayList<Property> list = new ArrayList<Property>(8);
        list.add(SgfId.GOOD_FOR_BLACK.makeProperty(SgfDouble.EMPHASIZED));
        list.add(SgfId.GOOD_FOR_BLACK.makeProperty(SgfDouble.NORMAL));
        list.add(SgfId.GOOD_FOR_WHITE.makeProperty(SgfDouble.EMPHASIZED));
        list.add(SgfId.GOOD_FOR_WHITE.makeProperty(SgfDouble.NORMAL));
        list.add(SgfId.EVEN_POSITION.makeProperty(SgfDouble.EMPHASIZED));
        list.add(SgfId.EVEN_POSITION.makeProperty(SgfDouble.NORMAL));
        list.add(SgfId.UNCLEAR_POS.makeProperty(SgfDouble.EMPHASIZED));
        list.add(SgfId.UNCLEAR_POS.makeProperty(SgfDouble.NORMAL));
        exclusives_s_ = Collections.unmodifiableSet(new HashSet(list));
        LB_ADD = new MessageResource(SetPositionValueAction.class, "lbAdd");
        LB_REMOVE = new MessageResource(SetPositionValueAction.class, "lbRemove");
        CLB_NO_VALUE = new MessageResource(SetPositionValueAction.class, "clbNoValue");
    }

    public SetPositionValueAction(WindowController controller, Property property) {
        super(controller);
        this.property_ = property == null ? null : new Property(property);
        this.provider_ = new BasicPropertyLabelProvider();
        this.controller_.addListener(this.adapter_);
        this.gameType_ = GameType.GAME;
        HashSet<Property> set = new HashSet<Property>(exclusives_s_);
        if (this.property_ == null) {
            this.isAddMode_ = false;
            this.setText(CLB_NO_VALUE.get());
            set.add(SgfId.HOTSPOT.makeProperty(SgfDouble.EMPHASIZED));
            set.add(SgfId.HOTSPOT.makeProperty(SgfDouble.NORMAL));
        } else {
            if (this.property_.sgfId().valueType() != ValueType.DOUBLE) {
                throw new IllegalArgumentException();
            }
            this.isAddMode_ = true;
            this.updateText();
            if (set.remove(this.property_)) {
                set.remove(this.property_.sgfId().makeProperty(SgfDouble.EMPHASIZED));
                set.remove(this.property_.sgfId().makeProperty(SgfDouble.NORMAL));
            } else {
                set.clear();
            }
        }
        this.exclusives_ = set.toArray(new Property[set.size()]);
        this.setEnabled(false);
    }

    @Override
    public Object getAdapter(Class<?> adapter) {
        if (adapter == null) {
            return null;
        }
        if (adapter.isAssignableFrom(this.adapter_.getClass())) {
            return this.adapter_;
        }
        return null;
    }

    @Override
    public void run() {
        UpdateProperty command = this.isAddMode_ || this.property_ == null ? new UpdateProperty(this.exclusives_, this.property_, null) : new UpdateProperty(new Property[]{this.property_}, null, null);
        this.controller_.getActive().getEventBroker().executeCommand(command);
    }

    private void updateText() {
        if (this.property_ == null) {
            this.setText(CLB_NO_VALUE.get());
            return;
        }
        this.setText(this.isAddMode_ ? LB_ADD.get(this.property_.toSgf(), this.provider_.getLabel(this.gameType_, this.property_)) : LB_REMOVE.get(this.property_.toSgf(), this.provider_.getLabel(this.gameType_, this.property_)));
    }

    private class Adapter
    implements GameViewer,
    NodeViewer,
    ControllerStatusViewer,
    WindowControllerListener {
        private Reference<GameFrameController> refGfc_ = new WeakReference<Object>(null);

        Adapter() {
        }

        public void changeActive(GameFrameController now) {
            GameFrameController last = this.refGfc_.get();
            if (last != null) {
                last.getEventBroker().removeView(SetPositionValueAction.this);
            }
            this.refGfc_ = new WeakReference<GameFrameController>(now);
            if (now == null) {
                SetPositionValueAction.this.setEnabled(false);
            } else {
                now.getEventBroker().addView(SetPositionValueAction.this);
                SetPositionValueAction.this.gameType_ = now.getCollectionEditor().getActiveGame().getGameType();
                SetPositionValueAction.this.setEnabled(now.isEditMode());
            }
        }

        public void update(GameMediator gameMediator) {
            ArgumentChecker.throwIfNull((Object)gameMediator);
            SetPositionValueAction.this.gameType_ = gameMediator.getGameType();
            this.update(gameMediator.getCurrentNodeView());
        }

        public void update(NodeView nodeView) {
            ArgumentChecker.throwIfNull((Object)nodeView);
            if (SetPositionValueAction.this.property_ == null) {
                SetPositionValueAction.this.isAddMode_ = false;
                SetPositionValueAction.this.setEnabled(false);
                Property[] propertyArray = SetPositionValueAction.this.exclusives_;
                int n = 0;
                int n2 = propertyArray.length;
                while (n < n2) {
                    Property property = propertyArray[n];
                    if (nodeView.getProperty(property.sgfId()) != null) {
                        SetPositionValueAction.this.setEnabled(true);
                    }
                    ++n;
                }
                return;
            }
            Property property = nodeView.getProperty(SetPositionValueAction.this.property_.sgfId());
            SetPositionValueAction.this.isAddMode_ = property == null || !property.value().getString().equals(SetPositionValueAction.this.property_.value().getString());
            if (nodeView.appends(SetPositionValueAction.this.property_.sgfId())) {
                SetPositionValueAction.this.setEnabled(true);
                SetPositionValueAction.this.updateText();
            } else {
                SetPositionValueAction.this.setEnabled(false);
                SetPositionValueAction.this.setText(BasicMessages.LB_NOT_IN_SERVICE.get());
            }
        }

        public void setEditMode(boolean isEditMode) {
            SetPositionValueAction.this.setEnabled(isEditMode);
        }

        public void changeHandlerPhase(HandlerPhase phase) {
        }
    }
}

